"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.debug = debug;
exports.warn = warn;
exports.error = error;
const chalk_1 = require("chalk");
const util_1 = require("util");
const LEVEL_COLORS = {
    debug: chalk_1.green,
    warn: chalk_1.yellow,
    error: chalk_1.red,
};
function label(level, message) {
    return `[@formatjs/ts-transformer] [${LEVEL_COLORS[level](level.toUpperCase())}] ${message}`;
}
async function debug(message, ...args) {
    if (process.env.LOG_LEVEL !== 'debug') {
        return;
    }
    console.error((0, util_1.format)(label('debug', message), ...args));
    console.error('\n');
}
function warn(message, ...args) {
    console.error((0, util_1.format)(label('warn', message), ...args));
    console.error('\n');
}
function error(message, ...args) {
    console.error((0, util_1.format)(label('error', message), ...args));
    console.error('\n');
}
