# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module NETWORK
      # @!group Attribute Names
    
      # Local address of the network connection - IP address or Unix domain socket name.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   10.1.2.80
      #   /tmp/my.sock
      #
      NETWORK_LOCAL_ADDRESS = 'network.local.address'
  
      # Local port number of the network connection.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   65123
      #
      NETWORK_LOCAL_PORT = 'network.local.port'
  
      # Peer address of the network connection - IP address or Unix domain socket name.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   10.1.2.80
      #   /tmp/my.sock
      #
      NETWORK_PEER_ADDRESS = 'network.peer.address'
  
      # Peer port number of the network connection.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   65123
      #
      NETWORK_PEER_PORT = 'network.peer.port'
  
      # [OSI application layer](https://wikipedia.org/wiki/Application_layer) or non-OSI equivalent.
      #
      # The value SHOULD be normalized to lowercase.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   amqp
      #   http
      #   mqtt
      #
      NETWORK_PROTOCOL_NAME = 'network.protocol.name'
  
      # The actual version of the protocol used for network communication.
      #
      # If protocol version is subject to negotiation (for example using [ALPN](https://www.rfc-editor.org/rfc/rfc7301.html)), this attribute SHOULD be set to the negotiated version. If the actual protocol version is not known, this attribute SHOULD NOT be set.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   1.1
      #   2
      #
      NETWORK_PROTOCOL_VERSION = 'network.protocol.version'
  
      # [OSI transport layer](https://wikipedia.org/wiki/Transport_layer) or [inter-process communication method](https://wikipedia.org/wiki/Inter-process_communication).
      #
      # The value SHOULD be normalized to lowercase.
      #
      # Consider always setting the transport when setting a port number, since
      # a port number is ambiguous without knowing the transport. For example
      # different processes could be listening on TCP port 12345 and UDP port 12345.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   tcp
      #   udp
      #
      NETWORK_TRANSPORT = 'network.transport'
  
      # [OSI network layer](https://wikipedia.org/wiki/Network_layer) or non-OSI equivalent.
      #
      # The value SHOULD be normalized to lowercase.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   ipv4
      #   ipv6
      #
      NETWORK_TYPE = 'network.type'
  
      # @!endgroup
    end
  end
end