# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module ZOS
        # @!group Attribute Names
      
        # The System Management Facility (SMF) Identifier uniquely identified a z/OS system within a SYSPLEX or mainframe environment and is used for system and performance analysis.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   SYS1
        #
        ZOS_SMF_ID = 'zos.smf.id'
    
        # The name of the SYSPLEX to which the z/OS system belongs too.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   SYSPLEX1
        #
        ZOS_SYSPLEX_NAME = 'zos.sysplex.name'
    
        # @!endgroup
      end
    end
  end
end