# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module WEBENGINE
        # @!group Attribute Names
      
        # Additional description of the web engine (e.g. detailed version and edition information).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   WildFly Full 21.0.0.Final (WildFly Core 13.0.1.Final) - 2.2.2.Final
        #
        WEBENGINE_DESCRIPTION = 'webengine.description'
    
        # The name of the web engine.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   WildFly
        #
        WEBENGINE_NAME = 'webengine.name'
    
        # The version of the web engine.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   21.0.0
        #
        WEBENGINE_VERSION = 'webengine.version'
    
        # @!endgroup
      end
    end
  end
end