# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module SERVER
        # @!group Attribute Names
      
        # Server domain name if available without reverse DNS lookup; otherwise, IP address or Unix domain socket name.
        #
        # When observed from the client side, and when communicating through an intermediary, `server.address` SHOULD represent the server address behind any intermediaries, for example proxies, if it's available.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   example.com
        #   10.1.2.80
        #   /tmp/my.sock
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::SERVER::SERVER_ADDRESS}.
        SERVER_ADDRESS = 'server.address'
    
        # Server port number.
        #
        # When observed from the client side, and when communicating through an intermediary, `server.port` SHOULD represent the server port behind any intermediaries, for example proxies, if it's available.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   80
        #   8080
        #   443
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::SERVER::SERVER_PORT}.
        SERVER_PORT = 'server.port'
    
        # @!endgroup
      end
    end
  end
end