# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module SECURITY_RULE
        # @!group Attribute Names
      
        # A categorization value keyword used by the entity using the rule for detection of this event
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Attempted Information Leak
        #
        SECURITY_RULE_CATEGORY = 'security_rule.category'
    
        # The description of the rule generating the event.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Block requests to public DNS over HTTPS / TLS protocols
        #
        SECURITY_RULE_DESCRIPTION = 'security_rule.description'
    
        # Name of the license under which the rule used to generate this event is made available.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Apache 2.0
        #
        SECURITY_RULE_LICENSE = 'security_rule.license'
    
        # The name of the rule or signature generating the event.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   BLOCK_DNS_over_TLS
        #
        SECURITY_RULE_NAME = 'security_rule.name'
    
        # Reference URL to additional information about the rule used to generate this event.
        #
        # The URL can point to the vendor’s documentation about the rule. If that’s not available, it can also be a link to a more general page describing this type of alert.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   https://en.wikipedia.org/wiki/DNS_over_TLS
        #
        SECURITY_RULE_REFERENCE = 'security_rule.reference'
    
        # Name of the ruleset, policy, group, or parent category in which the rule used to generate this event is a member.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Standard_Protocol_Filters
        #
        SECURITY_RULE_RULESET_NAME = 'security_rule.ruleset.name'
    
        # A rule ID that is unique within the scope of a set or group of agents, observers, or other entities using the rule for detection of this event.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   550e8400-e29b-41d4-a716-446655440000
        #   1100110011
        #
        SECURITY_RULE_UUID = 'security_rule.uuid'
    
        # The version / revision of the rule being used for analysis.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1.0.0
        #
        SECURITY_RULE_VERSION = 'security_rule.version'
    
        # @!endgroup
      end
    end
  end
end