# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module RPC
        # @!group Metrics Names
      
        # Measures the duration of outbound RPC.
        #
        # While streaming RPCs may record this metric as start-of-batch
        # to end-of-batch, it's hard to interpret in practice.
        #
        # **Streaming**: N/A.
        #
        # @note Stability Level: development
        RPC_CLIENT_DURATION = 'rpc.client.duration'
    
        # Measures the size of RPC request messages (uncompressed).
        #
        # **Streaming**: Recorded per message in a streaming batch
        #
        # @note Stability Level: development
        RPC_CLIENT_REQUEST_SIZE = 'rpc.client.request.size'
    
        # Measures the number of messages received per RPC.
        #
        # Should be 1 for all non-streaming RPCs.
        #
        # **Streaming**: This metric is required for server and client streaming RPCs
        #
        # @note Stability Level: development
        RPC_CLIENT_REQUESTS_PER_RPC = 'rpc.client.requests_per_rpc'
    
        # Measures the size of RPC response messages (uncompressed).
        #
        # **Streaming**: Recorded per response in a streaming batch
        #
        # @note Stability Level: development
        RPC_CLIENT_RESPONSE_SIZE = 'rpc.client.response.size'
    
        # Measures the number of messages sent per RPC.
        #
        # Should be 1 for all non-streaming RPCs.
        #
        # **Streaming**: This metric is required for server and client streaming RPCs
        #
        # @note Stability Level: development
        RPC_CLIENT_RESPONSES_PER_RPC = 'rpc.client.responses_per_rpc'
    
        # Measures the duration of inbound RPC.
        #
        # While streaming RPCs may record this metric as start-of-batch
        # to end-of-batch, it's hard to interpret in practice.
        #
        # **Streaming**: N/A.
        #
        # @note Stability Level: development
        RPC_SERVER_DURATION = 'rpc.server.duration'
    
        # Measures the size of RPC request messages (uncompressed).
        #
        # **Streaming**: Recorded per message in a streaming batch
        #
        # @note Stability Level: development
        RPC_SERVER_REQUEST_SIZE = 'rpc.server.request.size'
    
        # Measures the number of messages received per RPC.
        #
        # Should be 1 for all non-streaming RPCs.
        #
        # **Streaming** : This metric is required for server and client streaming RPCs
        #
        # @note Stability Level: development
        RPC_SERVER_REQUESTS_PER_RPC = 'rpc.server.requests_per_rpc'
    
        # Measures the size of RPC response messages (uncompressed).
        #
        # **Streaming**: Recorded per response in a streaming batch
        #
        # @note Stability Level: development
        RPC_SERVER_RESPONSE_SIZE = 'rpc.server.response.size'
    
        # Measures the number of messages sent per RPC.
        #
        # Should be 1 for all non-streaming RPCs.
        #
        # **Streaming**: This metric is required for server and client streaming RPCs
        #
        # @note Stability Level: development
        RPC_SERVER_RESPONSES_PER_RPC = 'rpc.server.responses_per_rpc'
    
        # @!endgroup
      end
    end
  end
end