# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module RPC
        # @!group Attribute Names
      
        # The [error codes](https://connectrpc.com//docs/protocol/#error-codes) of the Connect request. Error codes are always string values.
        #
        # @note Stability Level: development
        RPC_CONNECT_RPC_ERROR_CODE = 'rpc.connect_rpc.error_code'
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   RPC_CONNECT_RPC_REQUEST_METADATA_LAMBDA.call('some-cool-key') #=> 'rpc.connect_rpc.request.metadata.some-cool-key'
        #
        # Connect request metadata, `<key>` being the normalized Connect Metadata key (lowercase), the value being the metadata values.
        #
        # Instrumentations SHOULD require an explicit configuration of which metadata values are to be captured.
        # Including all request metadata values can be a security risk - explicit configuration helps avoid leaking sensitive information.
        #
        # For example, a property `my-custom-key` with value `["1.2.3.4", "1.2.3.5"]` SHOULD be recorded as
        # the `rpc.connect_rpc.request.metadata.my-custom-key` attribute with value `["1.2.3.4", "1.2.3.5"]`
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["1.2.3.4", "1.2.3.5"]
        #
        RPC_CONNECT_RPC_REQUEST_METADATA_LAMBDA = ->(key) { "rpc.connect_rpc.request.metadata.#{key}" }
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   RPC_CONNECT_RPC_RESPONSE_METADATA_LAMBDA.call('some-cool-key') #=> 'rpc.connect_rpc.response.metadata.some-cool-key'
        #
        # Connect response metadata, `<key>` being the normalized Connect Metadata key (lowercase), the value being the metadata values.
        #
        # Instrumentations SHOULD require an explicit configuration of which metadata values are to be captured.
        # Including all response metadata values can be a security risk - explicit configuration helps avoid leaking sensitive information.
        #
        # For example, a property `my-custom-key` with value `"attribute_value"` SHOULD be recorded as
        # the `rpc.connect_rpc.response.metadata.my-custom-key` attribute with value `["attribute_value"]`
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["attribute_value"]
        #
        RPC_CONNECT_RPC_RESPONSE_METADATA_LAMBDA = ->(key) { "rpc.connect_rpc.response.metadata.#{key}" }
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   RPC_GRPC_REQUEST_METADATA_LAMBDA.call('some-cool-key') #=> 'rpc.grpc.request.metadata.some-cool-key'
        #
        # gRPC request metadata, `<key>` being the normalized gRPC Metadata key (lowercase), the value being the metadata values.
        #
        # Instrumentations SHOULD require an explicit configuration of which metadata values are to be captured.
        # Including all request metadata values can be a security risk - explicit configuration helps avoid leaking sensitive information.
        #
        # For example, a property `my-custom-key` with value `["1.2.3.4", "1.2.3.5"]` SHOULD be recorded as
        # `rpc.grpc.request.metadata.my-custom-key` attribute with value `["1.2.3.4", "1.2.3.5"]`
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["1.2.3.4", "1.2.3.5"]
        #
        RPC_GRPC_REQUEST_METADATA_LAMBDA = ->(key) { "rpc.grpc.request.metadata.#{key}" }
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   RPC_GRPC_RESPONSE_METADATA_LAMBDA.call('some-cool-key') #=> 'rpc.grpc.response.metadata.some-cool-key'
        #
        # gRPC response metadata, `<key>` being the normalized gRPC Metadata key (lowercase), the value being the metadata values.
        #
        # Instrumentations SHOULD require an explicit configuration of which metadata values are to be captured.
        # Including all response metadata values can be a security risk - explicit configuration helps avoid leaking sensitive information.
        #
        # For example, a property `my-custom-key` with value `["attribute_value"]` SHOULD be recorded as
        # the `rpc.grpc.response.metadata.my-custom-key` attribute with value `["attribute_value"]`
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["attribute_value"]
        #
        RPC_GRPC_RESPONSE_METADATA_LAMBDA = ->(key) { "rpc.grpc.response.metadata.#{key}" }
    
        # The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
        #
        # @note Stability Level: development
        RPC_GRPC_STATUS_CODE = 'rpc.grpc.status_code'
    
        # `error.code` property of response if it is an error response.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   -32700
        #   100
        #
        RPC_JSONRPC_ERROR_CODE = 'rpc.jsonrpc.error_code'
    
        # `error.message` property of response if it is an error response.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Parse error
        #   User already exists
        #
        RPC_JSONRPC_ERROR_MESSAGE = 'rpc.jsonrpc.error_message'
    
        # `id` property of request or response. Since protocol allows id to be int, string, `null` or missing (for notifications), value is expected to be cast to string for simplicity. Use empty string in case of `null` value. Omit entirely if this is a notification.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   10
        #   request-7
        #   
        #
        RPC_JSONRPC_REQUEST_ID = 'rpc.jsonrpc.request_id'
    
        # Protocol version as in `jsonrpc` property of request/response. Since JSON-RPC 1.0 doesn't specify this, the value can be omitted.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   2.0
        #   1.0
        #
        RPC_JSONRPC_VERSION = 'rpc.jsonrpc.version'
    
        # Compressed size of the message in bytes.
        #
        # @note Stability Level: development
        RPC_MESSAGE_COMPRESSED_SIZE = 'rpc.message.compressed_size'
    
        # MUST be calculated as two different counters starting from `1` one for sent messages and one for received message.
        #
        # This way we guarantee that the values will be consistent between different implementations.
        #
        # @note Stability Level: development
        RPC_MESSAGE_ID = 'rpc.message.id'
    
        # Whether this is a received or sent message.
        #
        # @note Stability Level: development
        RPC_MESSAGE_TYPE = 'rpc.message.type'
    
        # Uncompressed size of the message in bytes.
        #
        # @note Stability Level: development
        RPC_MESSAGE_UNCOMPRESSED_SIZE = 'rpc.message.uncompressed_size'
    
        # The name of the (logical) method being called, must be equal to the $method part in the span name.
        #
        # This is the logical name of the method from the RPC interface perspective, which can be different from the name of any implementing method/function. The `code.function.name` attribute may be used to store the latter (e.g., method actually executing the call on the server side, RPC client stub method on the client side).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   exampleMethod
        #
        RPC_METHOD = 'rpc.method'
    
        # The full (logical) name of the service being called, including its package name, if applicable.
        #
        # This is the logical name of the service from the RPC interface perspective, which can be different from the name of any implementing class. The `code.namespace` attribute may be used to store the latter (despite the attribute name, it may include a class name; e.g., class with method actually executing the call on the server side, RPC client stub class on the client side).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   myservice.EchoService
        #
        RPC_SERVICE = 'rpc.service'
    
        # A string identifying the remoting system. See below for a list of well-known identifiers.
        #
        # @note Stability Level: development
        RPC_SYSTEM = 'rpc.system'
    
        # @!endgroup
      end
    end
  end
end