# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module PROCESS
        # @!group Attribute Names
      
        # Length of the process.command_args array
        #
        # This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   4
        #
        PROCESS_ARGS_COUNT = 'process.args_count'
    
        # The command used to launch the process (i.e. the command name). On Linux based systems, can be set to the zeroth string in `proc/[pid]/cmdline`. On Windows, can be set to the first parameter extracted from `GetCommandLineW`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   cmd/otelcol
        #
        PROCESS_COMMAND = 'process.command'
    
        # All the command arguments (including the command/executable itself) as received by the process. On Linux-based systems (and some other Unixoid systems supporting procfs), can be set according to the list of null-delimited strings extracted from `proc/[pid]/cmdline`. For libc-based executables, this would be the full argv vector passed to `main`. SHOULD NOT be collected by default unless there is sanitization that excludes sensitive data.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["cmd/otecol", "--config=config.yaml"]
        #
        PROCESS_COMMAND_ARGS = 'process.command_args'
    
        # The full command used to launch the process as a single string representing the full command. On Windows, can be set to the result of `GetCommandLineW`. Do not set this if you have to assemble it just for monitoring; use `process.command_args` instead. SHOULD NOT be collected by default unless there is sanitization that excludes sensitive data.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   C:\cmd\otecol --config="my directory\config.yaml"
        #
        PROCESS_COMMAND_LINE = 'process.command_line'
    
        # Specifies whether the context switches for this data point were voluntary or involuntary.
        #
        # @note Stability Level: development
        PROCESS_CONTEXT_SWITCH_TYPE = 'process.context_switch_type'
    
        # Deprecated, use `cpu.mode` instead.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Replaced by `cpu.mode`.", "reason": "renamed", "renamed_to": "cpu.mode"}
        PROCESS_CPU_STATE = 'process.cpu.state'
    
        # The date and time the process was created, in ISO 8601 format.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   2023-11-21T09:25:34.853Z
        #
        PROCESS_CREATION_TIME = 'process.creation.time'
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   PROCESS_ENVIRONMENT_VARIABLE_LAMBDA.call('some-cool-key') #=> 'process.environment_variable.some-cool-key'
        #
        # Process environment variables, `<key>` being the environment variable name, the value being the environment variable value.
        #
        # Examples:
        #
        # - an environment variable `USER` with value `"ubuntu"` SHOULD be recorded
        #   as the `process.environment_variable.USER` attribute with value `"ubuntu"`.
        # - an environment variable `PATH` with value `"/usr/local/bin:/usr/bin"`
        #   SHOULD be recorded as the `process.environment_variable.PATH` attribute
        #   with value `"/usr/local/bin:/usr/bin"`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ubuntu
        #   /usr/local/bin:/usr/bin
        #
        PROCESS_ENVIRONMENT_VARIABLE_LAMBDA = ->(key) { "process.environment_variable.#{key}" }
    
        # The GNU build ID as found in the `.note.gnu.build-id` ELF section (hex string).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   c89b11207f6479603b0d49bf291c092c2b719293
        #
        PROCESS_EXECUTABLE_BUILD_ID_GNU = 'process.executable.build_id.gnu'
    
        # The Go build ID as retrieved by `go tool buildid <go executable>`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   foh3mEXu7BLZjsN9pOwG/kATcXlYVCDEFouRMQed_/WwRFB1hPo9LBkekthSPG/x8hMC8emW2cCjXD0_1aY
        #
        PROCESS_EXECUTABLE_BUILD_ID_GO = 'process.executable.build_id.go'
    
        # Profiling specific build ID for executables. See the OTel specification for Profiles for more information.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   600DCAFE4A110000F2BF38C493F5FB92
        #
        PROCESS_EXECUTABLE_BUILD_ID_HTLHASH = 'process.executable.build_id.htlhash'
    
        # "Deprecated, use `process.executable.build_id.htlhash` instead."
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   600DCAFE4A110000F2BF38C493F5FB92
        #
        # @deprecated {"note": "Replaced by `process.executable.build_id.htlhash`.", "reason": "renamed", "renamed_to": "process.executable.build_id.htlhash"}
        PROCESS_EXECUTABLE_BUILD_ID_PROFILING = 'process.executable.build_id.profiling'
    
        # The name of the process executable. On Linux based systems, this SHOULD be set to the base name of the target of `/proc/[pid]/exe`. On Windows, this SHOULD be set to the base name of `GetProcessImageFileNameW`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   otelcol
        #
        PROCESS_EXECUTABLE_NAME = 'process.executable.name'
    
        # The full path to the process executable. On Linux based systems, can be set to the target of `proc/[pid]/exe`. On Windows, can be set to the result of `GetProcessImageFileNameW`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   /usr/bin/cmd/otelcol
        #
        PROCESS_EXECUTABLE_PATH = 'process.executable.path'
    
        # The exit code of the process.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   127
        #
        PROCESS_EXIT_CODE = 'process.exit.code'
    
        # The date and time the process exited, in ISO 8601 format.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   2023-11-21T09:26:12.315Z
        #
        PROCESS_EXIT_TIME = 'process.exit.time'
    
        # The PID of the process's group leader. This is also the process group ID (PGID) of the process.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   23
        #
        PROCESS_GROUP_LEADER_PID = 'process.group_leader.pid'
    
        # Whether the process is connected to an interactive shell.
        #
        # @note Stability Level: development
        PROCESS_INTERACTIVE = 'process.interactive'
    
        # The control group associated with the process.
        #
        # Control groups (cgroups) are a kernel feature used to organize and manage process resources. This attribute provides the path(s) to the cgroup(s) associated with the process, which should match the contents of the [/proc/[PID]/cgroup](https://man7.org/linux/man-pages/man7/cgroups.7.html) file.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1:name=systemd:/user.slice/user-1000.slice/session-3.scope
        #   0::/user.slice/user-1000.slice/user@1000.service/tmux-spawn-0267755b-4639-4a27-90ed-f19f88e53748.scope
        #
        PROCESS_LINUX_CGROUP = 'process.linux.cgroup'
    
        # The username of the user that owns the process.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   root
        #
        PROCESS_OWNER = 'process.owner'
    
        # The type of page fault for this data point. Type `major` is for major/hard page faults, and `minor` is for minor/soft page faults.
        #
        # @note Stability Level: development
        PROCESS_PAGING_FAULT_TYPE = 'process.paging.fault_type'
    
        # Parent Process identifier (PPID).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   111
        #
        PROCESS_PARENT_PID = 'process.parent_pid'
    
        # Process identifier (PID).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1234
        #
        PROCESS_PID = 'process.pid'
    
        # The real user ID (RUID) of the process.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1000
        #
        PROCESS_REAL_USER_ID = 'process.real_user.id'
    
        # The username of the real user of the process.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   operator
        #
        PROCESS_REAL_USER_NAME = 'process.real_user.name'
    
        # An additional description about the runtime of the process, for example a specific vendor customization of the runtime environment.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Eclipse OpenJ9 Eclipse OpenJ9 VM openj9-0.21.0
        #
        PROCESS_RUNTIME_DESCRIPTION = 'process.runtime.description'
    
        # The name of the runtime of this process.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   OpenJDK Runtime Environment
        #
        PROCESS_RUNTIME_NAME = 'process.runtime.name'
    
        # The version of the runtime of this process, as returned by the runtime without modification.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   14.0.2
        #
        PROCESS_RUNTIME_VERSION = 'process.runtime.version'
    
        # The saved user ID (SUID) of the process.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1002
        #
        PROCESS_SAVED_USER_ID = 'process.saved_user.id'
    
        # The username of the saved user.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   operator
        #
        PROCESS_SAVED_USER_NAME = 'process.saved_user.name'
    
        # The PID of the process's session leader. This is also the session ID (SID) of the process.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   14
        #
        PROCESS_SESSION_LEADER_PID = 'process.session_leader.pid'
    
        # Process title (proctitle)
        #
        # In many Unix-like systems, process title (proctitle), is the string that represents the name or command line of a running process, displayed by system monitoring tools like ps, top, and htop.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   cat /etc/hostname
        #   xfce4-session
        #   bash
        #
        PROCESS_TITLE = 'process.title'
    
        # The effective user ID (EUID) of the process.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1001
        #
        PROCESS_USER_ID = 'process.user.id'
    
        # The username of the effective user of the process.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   root
        #
        PROCESS_USER_NAME = 'process.user.name'
    
        # Virtual process identifier.
        #
        # The process ID within a PID namespace. This is not necessarily unique across all processes on the host but it is unique within the process namespace that the process exists within.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   12
        #
        PROCESS_VPID = 'process.vpid'
    
        # The working directory of the process.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   /root
        #
        PROCESS_WORKING_DIRECTORY = 'process.working_directory'
    
        # @!endgroup
      end
    end
  end
end