# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module OTEL
        # @!group Attribute Names
      
        # A name uniquely identifying the instance of the OpenTelemetry component within its containing SDK instance.
        #
        # Implementations SHOULD ensure a low cardinality for this attribute, even across application or SDK restarts.
        # E.g. implementations MUST NOT use UUIDs as values for this attribute.
        #
        # Implementations MAY achieve these goals by following a `<otel.component.type>/<instance-counter>` pattern, e.g. `batching_span_processor/0`.
        # Hereby `otel.component.type` refers to the corresponding attribute value of the component.
        #
        # The value of `instance-counter` MAY be automatically assigned by the component and uniqueness within the enclosing SDK instance MUST be guaranteed.
        # For example, `<instance-counter>` MAY be implemented by using a monotonically increasing counter (starting with `0`), which is incremented every time an
        # instance of the given component type is started.
        #
        # With this implementation, for example the first Batching Span Processor would have `batching_span_processor/0`
        # as `otel.component.name`, the second one `batching_span_processor/1` and so on.
        # These values will therefore be reused in the case of an application restart.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   otlp_grpc_span_exporter/0
        #   custom-name
        #
        OTEL_COMPONENT_NAME = 'otel.component.name'
    
        # A name identifying the type of the OpenTelemetry component.
        #
        # If none of the standardized values apply, implementations SHOULD use the language-defined name of the type.
        # E.g. for Java the fully qualified classname SHOULD be used in this case.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   batching_span_processor
        #   com.example.MySpanExporter
        #
        OTEL_COMPONENT_TYPE = 'otel.component.type'
    
        # Deprecated. Use the `otel.scope.name` attribute
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   io.opentelemetry.contrib.mongodb
        #
        # @deprecated {"note": "Replaced by `otel.scope.name`.", "reason": "renamed", "renamed_to": "otel.scope.name"}
        OTEL_LIBRARY_NAME = 'otel.library.name'
    
        # Deprecated. Use the `otel.scope.version` attribute.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1.0.0
        #
        # @deprecated {"note": "Replaced by `otel.scope.version`.", "reason": "renamed", "renamed_to": "otel.scope.version"}
        OTEL_LIBRARY_VERSION = 'otel.library.version'
    
        # The name of the instrumentation scope - (`InstrumentationScope.Name` in OTLP).
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   io.opentelemetry.contrib.mongodb
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::OTEL::OTEL_SCOPE_NAME}.
        OTEL_SCOPE_NAME = 'otel.scope.name'
    
        # The version of the instrumentation scope - (`InstrumentationScope.Version` in OTLP).
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   1.0.0
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::OTEL::OTEL_SCOPE_VERSION}.
        OTEL_SCOPE_VERSION = 'otel.scope.version'
    
        # Determines whether the span has a parent span, and if so, [whether it is a remote parent](https://opentelemetry.io/docs/specs/otel/trace/api/#isremote)
        #
        # @note Stability Level: development
        OTEL_SPAN_PARENT_ORIGIN = 'otel.span.parent.origin'
    
        # The result value of the sampler for this span
        #
        # @note Stability Level: development
        OTEL_SPAN_SAMPLING_RESULT = 'otel.span.sampling_result'
    
        # Name of the code, either "OK" or "ERROR". MUST NOT be set if the status code is UNSET.
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::OTEL::OTEL_STATUS_CODE}.
        OTEL_STATUS_CODE = 'otel.status_code'
    
        # Description of the Status if it has a value, otherwise not set.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   resource not found
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::OTEL::OTEL_STATUS_DESCRIPTION}.
        OTEL_STATUS_DESCRIPTION = 'otel.status_description'
    
        # @!endgroup
      end
    end
  end
end