# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module NODEJS
        # @!group Metrics Names
      
        # Event loop maximum delay.
        #
        # Value can be retrieved from value `histogram.max` of [`perf_hooks.monitorEventLoopDelay([options])`](https://nodejs.org/api/perf_hooks.html#perf_hooksmonitoreventloopdelayoptions)
        #
        # @note Stability Level: development
        NODEJS_EVENTLOOP_DELAY_MAX = 'nodejs.eventloop.delay.max'
    
        # Event loop mean delay.
        #
        # Value can be retrieved from value `histogram.mean` of [`perf_hooks.monitorEventLoopDelay([options])`](https://nodejs.org/api/perf_hooks.html#perf_hooksmonitoreventloopdelayoptions)
        #
        # @note Stability Level: development
        NODEJS_EVENTLOOP_DELAY_MEAN = 'nodejs.eventloop.delay.mean'
    
        # Event loop minimum delay.
        #
        # Value can be retrieved from value `histogram.min` of [`perf_hooks.monitorEventLoopDelay([options])`](https://nodejs.org/api/perf_hooks.html#perf_hooksmonitoreventloopdelayoptions)
        #
        # @note Stability Level: development
        NODEJS_EVENTLOOP_DELAY_MIN = 'nodejs.eventloop.delay.min'
    
        # Event loop 50 percentile delay.
        #
        # Value can be retrieved from value `histogram.percentile(50)` of [`perf_hooks.monitorEventLoopDelay([options])`](https://nodejs.org/api/perf_hooks.html#perf_hooksmonitoreventloopdelayoptions)
        #
        # @note Stability Level: development
        NODEJS_EVENTLOOP_DELAY_P50 = 'nodejs.eventloop.delay.p50'
    
        # Event loop 90 percentile delay.
        #
        # Value can be retrieved from value `histogram.percentile(90)` of [`perf_hooks.monitorEventLoopDelay([options])`](https://nodejs.org/api/perf_hooks.html#perf_hooksmonitoreventloopdelayoptions)
        #
        # @note Stability Level: development
        NODEJS_EVENTLOOP_DELAY_P90 = 'nodejs.eventloop.delay.p90'
    
        # Event loop 99 percentile delay.
        #
        # Value can be retrieved from value `histogram.percentile(99)` of [`perf_hooks.monitorEventLoopDelay([options])`](https://nodejs.org/api/perf_hooks.html#perf_hooksmonitoreventloopdelayoptions)
        #
        # @note Stability Level: development
        NODEJS_EVENTLOOP_DELAY_P99 = 'nodejs.eventloop.delay.p99'
    
        # Event loop standard deviation delay.
        #
        # Value can be retrieved from value `histogram.stddev` of [`perf_hooks.monitorEventLoopDelay([options])`](https://nodejs.org/api/perf_hooks.html#perf_hooksmonitoreventloopdelayoptions)
        #
        # @note Stability Level: development
        NODEJS_EVENTLOOP_DELAY_STDDEV = 'nodejs.eventloop.delay.stddev'
    
        # Cumulative duration of time the event loop has been in each state.
        #
        # Value can be retrieved from [`performance.eventLoopUtilization([utilization1[, utilization2]])`](https://nodejs.org/api/perf_hooks.html#performanceeventlooputilizationutilization1-utilization2)
        #
        # @note Stability Level: development
        NODEJS_EVENTLOOP_TIME = 'nodejs.eventloop.time'
    
        # Event loop utilization.
        #
        # The value range is [0.0, 1.0] and can be retrieved from [`performance.eventLoopUtilization([utilization1[, utilization2]])`](https://nodejs.org/api/perf_hooks.html#performanceeventlooputilizationutilization1-utilization2)
        #
        # @note Stability Level: development
        NODEJS_EVENTLOOP_UTILIZATION = 'nodejs.eventloop.utilization'
    
        # @!endgroup
      end
    end
  end
end