# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module MESSAGING
        # @!group Metrics Names
      
        # Number of messages that were delivered to the application.
        #
        # Records the number of messages pulled from the broker or number of messages dispatched to the application in push-based scenarios.
        # The metric SHOULD be reported once per message delivery. For example, if receiving and processing operations are both instrumented for a single message delivery, this counter is incremented when the message is received and not reported when it is processed.
        #
        # @note Stability Level: development
        MESSAGING_CLIENT_CONSUMED_MESSAGES = 'messaging.client.consumed.messages'
    
        # Duration of messaging operation initiated by a producer or consumer client.
        #
        # This metric SHOULD NOT be used to report processing duration - processing duration is reported in `messaging.process.duration` metric.
        #
        # @note Stability Level: development
        MESSAGING_CLIENT_OPERATION_DURATION = 'messaging.client.operation.duration'
    
        # Deprecated. Use `messaging.client.sent.messages` instead.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Replaced by `messaging.client.sent.messages`.", "reason": "renamed", "renamed_to": "messaging.client.sent.messages"}
        MESSAGING_CLIENT_PUBLISHED_MESSAGES = 'messaging.client.published.messages'
    
        # Number of messages producer attempted to send to the broker.
        #
        # This metric MUST NOT count messages that were created but haven't yet been sent.
        #
        # @note Stability Level: development
        MESSAGING_CLIENT_SENT_MESSAGES = 'messaging.client.sent.messages'
    
        # Duration of processing operation.
        #
        # This metric MUST be reported for operations with `messaging.operation.type` that matches `process`.
        #
        # @note Stability Level: development
        MESSAGING_PROCESS_DURATION = 'messaging.process.duration'
    
        # Deprecated. Use `messaging.client.consumed.messages` instead.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Replaced by `messaging.client.consumed.messages`.", "reason": "renamed", "renamed_to": "messaging.client.consumed.messages"}
        MESSAGING_PROCESS_MESSAGES = 'messaging.process.messages'
    
        # Deprecated. Use `messaging.client.operation.duration` instead.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Replaced by `messaging.client.operation.duration`.", "reason": "renamed", "renamed_to": "messaging.client.operation.duration"}
        MESSAGING_PUBLISH_DURATION = 'messaging.publish.duration'
    
        # Deprecated. Use `messaging.client.sent.messages` instead.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Replaced by `messaging.client.sent.messages`.", "reason": "renamed", "renamed_to": "messaging.client.sent.messages"}
        MESSAGING_PUBLISH_MESSAGES = 'messaging.publish.messages'
    
        # Deprecated. Use `messaging.client.operation.duration` instead.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Replaced by `messaging.client.operation.duration`.", "reason": "renamed", "renamed_to": "messaging.client.operation.duration"}
        MESSAGING_RECEIVE_DURATION = 'messaging.receive.duration'
    
        # Deprecated. Use `messaging.client.consumed.messages` instead.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Replaced by `messaging.client.consumed.messages`.", "reason": "renamed", "renamed_to": "messaging.client.consumed.messages"}
        MESSAGING_RECEIVE_MESSAGES = 'messaging.receive.messages'
    
        # @!endgroup
      end
    end
  end
end