# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module K8S
        # @!group Attribute Names
      
        # The name of the cluster.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   opentelemetry-cluster
        #
        K8S_CLUSTER_NAME = 'k8s.cluster.name'
    
        # A pseudo-ID for the cluster, set to the UID of the `kube-system` namespace.
        #
        # K8s doesn't have support for obtaining a cluster ID. If this is ever
        # added, we will recommend collecting the `k8s.cluster.uid` through the
        # official APIs. In the meantime, we are able to use the `uid` of the
        # `kube-system` namespace as a proxy for cluster ID. Read on for the
        # rationale.
        #
        # Every object created in a K8s cluster is assigned a distinct UID. The
        # `kube-system` namespace is used by Kubernetes itself and will exist
        # for the lifetime of the cluster. Using the `uid` of the `kube-system`
        # namespace is a reasonable proxy for the K8s ClusterID as it will only
        # change if the cluster is rebuilt. Furthermore, Kubernetes UIDs are
        # UUIDs as standardized by
        # [ISO/IEC 9834-8 and ITU-T X.667](https://www.itu.int/ITU-T/studygroups/com17/oid.html).
        # Which states:
        #
        # > If generated according to one of the mechanisms defined in Rec.
        # > ITU-T X.667 | ISO/IEC 9834-8, a UUID is either guaranteed to be
        # > different from all other UUIDs generated before 3603 A.D., or is
        # > extremely likely to be different (depending on the mechanism chosen).
        #
        # Therefore, UIDs between clusters should be extremely unlikely to
        # conflict.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   218fc5a9-a5f1-4b54-aa05-46717d0ab26d
        #
        K8S_CLUSTER_UID = 'k8s.cluster.uid'
    
        # The name of the Container from Pod specification, must be unique within a Pod. Container runtime usually uses different globally unique name (`container.name`).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   redis
        #
        K8S_CONTAINER_NAME = 'k8s.container.name'
    
        # Number of times the container was restarted. This attribute can be used to identify a particular container (running or stopped) within a container spec.
        #
        # @note Stability Level: development
        K8S_CONTAINER_RESTART_COUNT = 'k8s.container.restart_count'
    
        # Last terminated reason of the Container.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Evicted
        #   Error
        #
        K8S_CONTAINER_STATUS_LAST_TERMINATED_REASON = 'k8s.container.status.last_terminated_reason'
    
        # The reason for the container state. Corresponds to the `reason` field of the: [K8s ContainerStateWaiting](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#containerstatewaiting-v1-core) or [K8s ContainerStateTerminated](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#containerstateterminated-v1-core)
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ContainerCreating
        #   CrashLoopBackOff
        #   CreateContainerConfigError
        #   ErrImagePull
        #   ImagePullBackOff
        #   OOMKilled
        #   Completed
        #   Error
        #   ContainerCannotRun
        #
        K8S_CONTAINER_STATUS_REASON = 'k8s.container.status.reason'
    
        # The state of the container. [K8s ContainerState](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#containerstate-v1-core)
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   terminated
        #   running
        #   waiting
        #
        K8S_CONTAINER_STATUS_STATE = 'k8s.container.status.state'
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_CRONJOB_ANNOTATION_LAMBDA.call('some-cool-key') #=> 'k8s.cronjob.annotation.some-cool-key'
        #
        # The cronjob annotation placed on the CronJob, the `<key>` being the annotation name, the value being the annotation value.
        #
        # Examples:
        #
        # - An annotation `retries` with value `4` SHOULD be recorded as the
        #   `k8s.cronjob.annotation.retries` attribute with value `"4"`.
        # - An annotation `data` with empty string value SHOULD be recorded as
        #   the `k8s.cronjob.annotation.data` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   4
        #   
        #
        K8S_CRONJOB_ANNOTATION_LAMBDA = ->(key) { "k8s.cronjob.annotation.#{key}" }
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_CRONJOB_LABEL_LAMBDA.call('some-cool-key') #=> 'k8s.cronjob.label.some-cool-key'
        #
        # The label placed on the CronJob, the `<key>` being the label name, the value being the label value.
        #
        # Examples:
        #
        # - A label `type` with value `weekly` SHOULD be recorded as the
        #   `k8s.cronjob.label.type` attribute with value `"weekly"`.
        # - A label `automated` with empty string value SHOULD be recorded as
        #   the `k8s.cronjob.label.automated` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   weekly
        #   
        #
        K8S_CRONJOB_LABEL_LAMBDA = ->(key) { "k8s.cronjob.label.#{key}" }
    
        # The name of the CronJob.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   opentelemetry
        #
        K8S_CRONJOB_NAME = 'k8s.cronjob.name'
    
        # The UID of the CronJob.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   275ecb36-5aa8-4c2a-9c47-d8bb681b9aff
        #
        K8S_CRONJOB_UID = 'k8s.cronjob.uid'
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_DAEMONSET_ANNOTATION_LAMBDA.call('some-cool-key') #=> 'k8s.daemonset.annotation.some-cool-key'
        #
        # The annotation placed on the DaemonSet, the `<key>` being the annotation name, the value being the annotation value, even if the value is empty.
        #
        # Examples:
        #
        # - A label `replicas` with value `1` SHOULD be recorded
        #   as the `k8s.daemonset.annotation.replicas` attribute with value `"1"`.
        # - A label `data` with empty string value SHOULD be recorded as
        #   the `k8s.daemonset.annotation.data` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1
        #   
        #
        K8S_DAEMONSET_ANNOTATION_LAMBDA = ->(key) { "k8s.daemonset.annotation.#{key}" }
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_DAEMONSET_LABEL_LAMBDA.call('some-cool-key') #=> 'k8s.daemonset.label.some-cool-key'
        #
        # The label placed on the DaemonSet, the `<key>` being the label name, the value being the label value, even if the value is empty.
        #
        # Examples:
        #
        # - A label `app` with value `guestbook` SHOULD be recorded
        #   as the `k8s.daemonset.label.app` attribute with value `"guestbook"`.
        # - A label `data` with empty string value SHOULD be recorded as
        #   the `k8s.daemonset.label.injected` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   guestbook
        #   
        #
        K8S_DAEMONSET_LABEL_LAMBDA = ->(key) { "k8s.daemonset.label.#{key}" }
    
        # The name of the DaemonSet.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   opentelemetry
        #
        K8S_DAEMONSET_NAME = 'k8s.daemonset.name'
    
        # The UID of the DaemonSet.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   275ecb36-5aa8-4c2a-9c47-d8bb681b9aff
        #
        K8S_DAEMONSET_UID = 'k8s.daemonset.uid'
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_DEPLOYMENT_ANNOTATION_LAMBDA.call('some-cool-key') #=> 'k8s.deployment.annotation.some-cool-key'
        #
        # The annotation placed on the Deployment, the `<key>` being the annotation name, the value being the annotation value, even if the value is empty.
        #
        # Examples:
        #
        # - A label `replicas` with value `1` SHOULD be recorded
        #   as the `k8s.deployment.annotation.replicas` attribute with value `"1"`.
        # - A label `data` with empty string value SHOULD be recorded as
        #   the `k8s.deployment.annotation.data` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1
        #   
        #
        K8S_DEPLOYMENT_ANNOTATION_LAMBDA = ->(key) { "k8s.deployment.annotation.#{key}" }
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_DEPLOYMENT_LABEL_LAMBDA.call('some-cool-key') #=> 'k8s.deployment.label.some-cool-key'
        #
        # The label placed on the Deployment, the `<key>` being the label name, the value being the label value, even if the value is empty.
        #
        # Examples:
        #
        # - A label `replicas` with value `0` SHOULD be recorded
        #   as the `k8s.deployment.label.app` attribute with value `"guestbook"`.
        # - A label `injected` with empty string value SHOULD be recorded as
        #   the `k8s.deployment.label.injected` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   guestbook
        #   
        #
        K8S_DEPLOYMENT_LABEL_LAMBDA = ->(key) { "k8s.deployment.label.#{key}" }
    
        # The name of the Deployment.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   opentelemetry
        #
        K8S_DEPLOYMENT_NAME = 'k8s.deployment.name'
    
        # The UID of the Deployment.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   275ecb36-5aa8-4c2a-9c47-d8bb681b9aff
        #
        K8S_DEPLOYMENT_UID = 'k8s.deployment.uid'
    
        # The type of metric source for the horizontal pod autoscaler.
        #
        # This attribute reflects the `type` field of spec.metrics[] in the HPA.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Resource
        #   ContainerResource
        #
        K8S_HPA_METRIC_TYPE = 'k8s.hpa.metric.type'
    
        # The name of the horizontal pod autoscaler.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   opentelemetry
        #
        K8S_HPA_NAME = 'k8s.hpa.name'
    
        # The API version of the target resource to scale for the HorizontalPodAutoscaler.
        #
        # This maps to the `apiVersion` field in the `scaleTargetRef` of the HPA spec.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   apps/v1
        #   autoscaling/v2
        #
        K8S_HPA_SCALETARGETREF_API_VERSION = 'k8s.hpa.scaletargetref.api_version'
    
        # The kind of the target resource to scale for the HorizontalPodAutoscaler.
        #
        # This maps to the `kind` field in the `scaleTargetRef` of the HPA spec.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Deployment
        #   StatefulSet
        #
        K8S_HPA_SCALETARGETREF_KIND = 'k8s.hpa.scaletargetref.kind'
    
        # The name of the target resource to scale for the HorizontalPodAutoscaler.
        #
        # This maps to the `name` field in the `scaleTargetRef` of the HPA spec.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   my-deployment
        #   my-statefulset
        #
        K8S_HPA_SCALETARGETREF_NAME = 'k8s.hpa.scaletargetref.name'
    
        # The UID of the horizontal pod autoscaler.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   275ecb36-5aa8-4c2a-9c47-d8bb681b9aff
        #
        K8S_HPA_UID = 'k8s.hpa.uid'
    
        # The size (identifier) of the K8s huge page.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   2Mi
        #
        K8S_HUGEPAGE_SIZE = 'k8s.hugepage.size'
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_JOB_ANNOTATION_LAMBDA.call('some-cool-key') #=> 'k8s.job.annotation.some-cool-key'
        #
        # The annotation placed on the Job, the `<key>` being the annotation name, the value being the annotation value, even if the value is empty.
        #
        # Examples:
        #
        # - A label `number` with value `1` SHOULD be recorded
        #   as the `k8s.job.annotation.number` attribute with value `"1"`.
        # - A label `data` with empty string value SHOULD be recorded as
        #   the `k8s.job.annotation.data` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1
        #   
        #
        K8S_JOB_ANNOTATION_LAMBDA = ->(key) { "k8s.job.annotation.#{key}" }
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_JOB_LABEL_LAMBDA.call('some-cool-key') #=> 'k8s.job.label.some-cool-key'
        #
        # The label placed on the Job, the `<key>` being the label name, the value being the label value, even if the value is empty.
        #
        # Examples:
        #
        # - A label `jobtype` with value `ci` SHOULD be recorded
        #   as the `k8s.job.label.jobtype` attribute with value `"ci"`.
        # - A label `data` with empty string value SHOULD be recorded as
        #   the `k8s.job.label.automated` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ci
        #   
        #
        K8S_JOB_LABEL_LAMBDA = ->(key) { "k8s.job.label.#{key}" }
    
        # The name of the Job.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   opentelemetry
        #
        K8S_JOB_NAME = 'k8s.job.name'
    
        # The UID of the Job.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   275ecb36-5aa8-4c2a-9c47-d8bb681b9aff
        #
        K8S_JOB_UID = 'k8s.job.uid'
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_NAMESPACE_ANNOTATION_LAMBDA.call('some-cool-key') #=> 'k8s.namespace.annotation.some-cool-key'
        #
        # The annotation placed on the Namespace, the `<key>` being the annotation name, the value being the annotation value, even if the value is empty.
        #
        # Examples:
        #
        # - A label `ttl` with value `0` SHOULD be recorded
        #   as the `k8s.namespace.annotation.ttl` attribute with value `"0"`.
        # - A label `data` with empty string value SHOULD be recorded as
        #   the `k8s.namespace.annotation.data` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0
        #   
        #
        K8S_NAMESPACE_ANNOTATION_LAMBDA = ->(key) { "k8s.namespace.annotation.#{key}" }
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_NAMESPACE_LABEL_LAMBDA.call('some-cool-key') #=> 'k8s.namespace.label.some-cool-key'
        #
        # The label placed on the Namespace, the `<key>` being the label name, the value being the label value, even if the value is empty.
        #
        # Examples:
        #
        # - A label `kubernetes.io/metadata.name` with value `default` SHOULD be recorded
        #   as the `k8s.namespace.label.kubernetes.io/metadata.name` attribute with value `"default"`.
        # - A label `data` with empty string value SHOULD be recorded as
        #   the `k8s.namespace.label.data` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   default
        #   
        #
        K8S_NAMESPACE_LABEL_LAMBDA = ->(key) { "k8s.namespace.label.#{key}" }
    
        # The name of the namespace that the pod is running in.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   default
        #
        K8S_NAMESPACE_NAME = 'k8s.namespace.name'
    
        # The phase of the K8s namespace.
        #
        # This attribute aligns with the `phase` field of the
        # [K8s NamespaceStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#namespacestatus-v1-core)
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   active
        #   terminating
        #
        K8S_NAMESPACE_PHASE = 'k8s.namespace.phase'
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_NODE_ANNOTATION_LAMBDA.call('some-cool-key') #=> 'k8s.node.annotation.some-cool-key'
        #
        # The annotation placed on the Node, the `<key>` being the annotation name, the value being the annotation value, even if the value is empty.
        #
        # Examples:
        #
        # - An annotation `node.alpha.kubernetes.io/ttl` with value `0` SHOULD be recorded as
        #   the `k8s.node.annotation.node.alpha.kubernetes.io/ttl` attribute with value `"0"`.
        # - An annotation `data` with empty string value SHOULD be recorded as
        #   the `k8s.node.annotation.data` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0
        #   
        #
        K8S_NODE_ANNOTATION_LAMBDA = ->(key) { "k8s.node.annotation.#{key}" }
    
        # The status of the condition, one of True, False, Unknown.
        #
        # This attribute aligns with the `status` field of the
        # [NodeCondition](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#nodecondition-v1-core)
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   true
        #   false
        #   unknown
        #
        K8S_NODE_CONDITION_STATUS = 'k8s.node.condition.status'
    
        # The condition type of a K8s Node.
        #
        # K8s Node conditions as described
        # by [K8s documentation](https://v1-32.docs.kubernetes.io/docs/reference/node/node-status/#condition).
        #
        # This attribute aligns with the `type` field of the
        # [NodeCondition](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#nodecondition-v1-core)
        #
        # The set of possible values is not limited to those listed here. Managed Kubernetes environments,
        # or custom controllers MAY introduce additional node condition types.
        # When this occurs, the exact value as reported by the Kubernetes API SHOULD be used.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Ready
        #   DiskPressure
        #
        K8S_NODE_CONDITION_TYPE = 'k8s.node.condition.type'
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_NODE_LABEL_LAMBDA.call('some-cool-key') #=> 'k8s.node.label.some-cool-key'
        #
        # The label placed on the Node, the `<key>` being the label name, the value being the label value, even if the value is empty.
        #
        # Examples:
        #
        # - A label `kubernetes.io/arch` with value `arm64` SHOULD be recorded
        #   as the `k8s.node.label.kubernetes.io/arch` attribute with value `"arm64"`.
        # - A label `data` with empty string value SHOULD be recorded as
        #   the `k8s.node.label.data` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   arm64
        #   
        #
        K8S_NODE_LABEL_LAMBDA = ->(key) { "k8s.node.label.#{key}" }
    
        # The name of the Node.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   node-1
        #
        K8S_NODE_NAME = 'k8s.node.name'
    
        # The UID of the Node.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1eb3a0c6-0477-4080-a9cb-0cb7db65c6a2
        #
        K8S_NODE_UID = 'k8s.node.uid'
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_POD_ANNOTATION_LAMBDA.call('some-cool-key') #=> 'k8s.pod.annotation.some-cool-key'
        #
        # The annotation placed on the Pod, the `<key>` being the annotation name, the value being the annotation value.
        #
        # Examples:
        #
        # - An annotation `kubernetes.io/enforce-mountable-secrets` with value `true` SHOULD be recorded as
        #   the `k8s.pod.annotation.kubernetes.io/enforce-mountable-secrets` attribute with value `"true"`.
        # - An annotation `mycompany.io/arch` with value `x64` SHOULD be recorded as
        #   the `k8s.pod.annotation.mycompany.io/arch` attribute with value `"x64"`.
        # - An annotation `data` with empty string value SHOULD be recorded as
        #   the `k8s.pod.annotation.data` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   true
        #   x64
        #   
        #
        K8S_POD_ANNOTATION_LAMBDA = ->(key) { "k8s.pod.annotation.#{key}" }
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_POD_LABEL_LAMBDA.call('some-cool-key') #=> 'k8s.pod.label.some-cool-key'
        #
        # The label placed on the Pod, the `<key>` being the label name, the value being the label value.
        #
        # Examples:
        #
        # - A label `app` with value `my-app` SHOULD be recorded as
        #   the `k8s.pod.label.app` attribute with value `"my-app"`.
        # - A label `mycompany.io/arch` with value `x64` SHOULD be recorded as
        #   the `k8s.pod.label.mycompany.io/arch` attribute with value `"x64"`.
        # - A label `data` with empty string value SHOULD be recorded as
        #   the `k8s.pod.label.data` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   my-app
        #   x64
        #   
        #
        K8S_POD_LABEL_LAMBDA = ->(key) { "k8s.pod.label.#{key}" }
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_POD_LABELS_LAMBDA.call('some-cool-key') #=> 'k8s.pod.labels.some-cool-key'
        #
        # Deprecated, use `k8s.pod.label` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   my-app
        #
        # @deprecated {"note": "Replaced by `k8s.pod.label`.", "reason": "renamed", "renamed_to": "k8s.pod.label"}
        K8S_POD_LABELS_LAMBDA = ->(key) { "k8s.pod.labels.#{key}" }
    
        # The name of the Pod.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   opentelemetry-pod-autoconf
        #
        K8S_POD_NAME = 'k8s.pod.name'
    
        # The UID of the Pod.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   275ecb36-5aa8-4c2a-9c47-d8bb681b9aff
        #
        K8S_POD_UID = 'k8s.pod.uid'
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_REPLICASET_ANNOTATION_LAMBDA.call('some-cool-key') #=> 'k8s.replicaset.annotation.some-cool-key'
        #
        # The annotation placed on the ReplicaSet, the `<key>` being the annotation name, the value being the annotation value, even if the value is empty.
        #
        # Examples:
        #
        # - A label `replicas` with value `0` SHOULD be recorded
        #   as the `k8s.replicaset.annotation.replicas` attribute with value `"0"`.
        # - A label `data` with empty string value SHOULD be recorded as
        #   the `k8s.replicaset.annotation.data` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0
        #   
        #
        K8S_REPLICASET_ANNOTATION_LAMBDA = ->(key) { "k8s.replicaset.annotation.#{key}" }
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_REPLICASET_LABEL_LAMBDA.call('some-cool-key') #=> 'k8s.replicaset.label.some-cool-key'
        #
        # The label placed on the ReplicaSet, the `<key>` being the label name, the value being the label value, even if the value is empty.
        #
        # Examples:
        #
        # - A label `app` with value `guestbook` SHOULD be recorded
        #   as the `k8s.replicaset.label.app` attribute with value `"guestbook"`.
        # - A label `injected` with empty string value SHOULD be recorded as
        #   the `k8s.replicaset.label.injected` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   guestbook
        #   
        #
        K8S_REPLICASET_LABEL_LAMBDA = ->(key) { "k8s.replicaset.label.#{key}" }
    
        # The name of the ReplicaSet.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   opentelemetry
        #
        K8S_REPLICASET_NAME = 'k8s.replicaset.name'
    
        # The UID of the ReplicaSet.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   275ecb36-5aa8-4c2a-9c47-d8bb681b9aff
        #
        K8S_REPLICASET_UID = 'k8s.replicaset.uid'
    
        # The name of the replication controller.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   opentelemetry
        #
        K8S_REPLICATIONCONTROLLER_NAME = 'k8s.replicationcontroller.name'
    
        # The UID of the replication controller.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   275ecb36-5aa8-4c2a-9c47-d8bb681b9aff
        #
        K8S_REPLICATIONCONTROLLER_UID = 'k8s.replicationcontroller.uid'
    
        # The name of the resource quota.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   opentelemetry
        #
        K8S_RESOURCEQUOTA_NAME = 'k8s.resourcequota.name'
    
        # The name of the K8s resource a resource quota defines.
        #
        # The value for this attribute can be either the full `count/<resource>[.<group>]` string (e.g., count/deployments.apps, count/pods), or, for certain core Kubernetes resources, just the resource name (e.g., pods, services, configmaps). Both forms are supported by Kubernetes for object count quotas. See [Kubernetes Resource Quotas documentation](https://kubernetes.io/docs/concepts/policy/resource-quotas/#object-count-quota) for more details.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   count/replicationcontrollers
        #
        K8S_RESOURCEQUOTA_RESOURCE_NAME = 'k8s.resourcequota.resource_name'
    
        # The UID of the resource quota.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   275ecb36-5aa8-4c2a-9c47-d8bb681b9aff
        #
        K8S_RESOURCEQUOTA_UID = 'k8s.resourcequota.uid'
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_STATEFULSET_ANNOTATION_LAMBDA.call('some-cool-key') #=> 'k8s.statefulset.annotation.some-cool-key'
        #
        # The annotation placed on the StatefulSet, the `<key>` being the annotation name, the value being the annotation value, even if the value is empty.
        #
        # Examples:
        #
        # - A label `replicas` with value `1` SHOULD be recorded
        #   as the `k8s.statefulset.annotation.replicas` attribute with value `"1"`.
        # - A label `data` with empty string value SHOULD be recorded as
        #   the `k8s.statefulset.annotation.data` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1
        #   
        #
        K8S_STATEFULSET_ANNOTATION_LAMBDA = ->(key) { "k8s.statefulset.annotation.#{key}" }
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   K8S_STATEFULSET_LABEL_LAMBDA.call('some-cool-key') #=> 'k8s.statefulset.label.some-cool-key'
        #
        # The label placed on the StatefulSet, the `<key>` being the label name, the value being the label value, even if the value is empty.
        #
        # Examples:
        #
        # - A label `replicas` with value `0` SHOULD be recorded
        #   as the `k8s.statefulset.label.app` attribute with value `"guestbook"`.
        # - A label `injected` with empty string value SHOULD be recorded as
        #   the `k8s.statefulset.label.injected` attribute with value `""`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   guestbook
        #   
        #
        K8S_STATEFULSET_LABEL_LAMBDA = ->(key) { "k8s.statefulset.label.#{key}" }
    
        # The name of the StatefulSet.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   opentelemetry
        #
        K8S_STATEFULSET_NAME = 'k8s.statefulset.name'
    
        # The UID of the StatefulSet.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   275ecb36-5aa8-4c2a-9c47-d8bb681b9aff
        #
        K8S_STATEFULSET_UID = 'k8s.statefulset.uid'
    
        # The name of K8s [StorageClass](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#storageclass-v1-storage-k8s-io) object.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   gold.storageclass.storage.k8s.io
        #
        K8S_STORAGECLASS_NAME = 'k8s.storageclass.name'
    
        # The name of the K8s volume.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   volume0
        #
        K8S_VOLUME_NAME = 'k8s.volume.name'
    
        # The type of the K8s volume.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   emptyDir
        #   persistentVolumeClaim
        #
        K8S_VOLUME_TYPE = 'k8s.volume.type'
    
        # @!endgroup
      end
    end
  end
end