# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module HOST
        # @!group Attribute Names
      
        # The CPU architecture the host system is running on.
        #
        # @note Stability Level: development
        HOST_ARCH = 'host.arch'
    
        # The amount of level 2 memory cache available to the processor (in Bytes).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   12288000
        #
        HOST_CPU_CACHE_L2_SIZE = 'host.cpu.cache.l2.size'
    
        # Family or generation of the CPU.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   6
        #   PA-RISC 1.1e
        #
        HOST_CPU_FAMILY = 'host.cpu.family'
    
        # Model identifier. It provides more granular information about the CPU, distinguishing it from other CPUs within the same family.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   6
        #   9000/778/B180L
        #
        HOST_CPU_MODEL_ID = 'host.cpu.model.id'
    
        # Model designation of the processor.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   11th Gen Intel(R) Core(TM) i7-1185G7 @ 3.00GHz
        #
        HOST_CPU_MODEL_NAME = 'host.cpu.model.name'
    
        # Stepping or core revisions.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1
        #   r1p1
        #
        HOST_CPU_STEPPING = 'host.cpu.stepping'
    
        # Processor manufacturer identifier. A maximum 12-character string.
        #
        # [CPUID](https://wiki.osdev.org/CPUID) command returns the vendor ID string in EBX, EDX and ECX registers. Writing these to memory in this order results in a 12-character string.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   GenuineIntel
        #
        HOST_CPU_VENDOR_ID = 'host.cpu.vendor.id'
    
        # Unique host ID. For Cloud, this must be the instance_id assigned by the cloud provider. For non-containerized systems, this should be the `machine-id`. See the table below for the sources to use to determine the `machine-id` based on operating system.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   fdbf79e8af94cb7f9e8df36789187052
        #
        HOST_ID = 'host.id'
    
        # VM image ID or host OS image ID. For Cloud, this value is from the provider.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ami-07b06b442921831e5
        #
        HOST_IMAGE_ID = 'host.image.id'
    
        # Name of the VM image or OS install the host was instantiated from.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   infra-ami-eks-worker-node-7d4ec78312
        #   CentOS-8-x86_64-1905
        #
        HOST_IMAGE_NAME = 'host.image.name'
    
        # The version string of the VM image or host OS as defined in [Version Attributes](/docs/resource/README.md#version-attributes).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0.1
        #
        HOST_IMAGE_VERSION = 'host.image.version'
    
        # Available IP addresses of the host, excluding loopback interfaces.
        #
        # IPv4 Addresses MUST be specified in dotted-quad notation. IPv6 addresses MUST be specified in the [RFC 5952](https://www.rfc-editor.org/rfc/rfc5952.html) format.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["192.168.1.140", "fe80::abc2:4a28:737a:609e"]
        #
        HOST_IP = 'host.ip'
    
        # Available MAC addresses of the host, excluding loopback interfaces.
        #
        # MAC Addresses MUST be represented in [IEEE RA hexadecimal form](https://standards.ieee.org/wp-content/uploads/import/documents/tutorials/eui.pdf): as hyphen-separated octets in uppercase hexadecimal form from most to least significant.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["AC-DE-48-23-45-67", "AC-DE-48-23-45-67-01-9F"]
        #
        HOST_MAC = 'host.mac'
    
        # Name of the host. On Unix systems, it may contain what the hostname command returns, or the fully qualified hostname, or another name specified by the user.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   opentelemetry-test
        #
        HOST_NAME = 'host.name'
    
        # Type of host. For Cloud, this must be the machine type.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   n1-standard-1
        #
        HOST_TYPE = 'host.type'
    
        # @!endgroup
      end
    end
  end
end