# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module GEO
        # @!group Attribute Names
      
        # Two-letter code representing continent’s name.
        #
        # @note Stability Level: development
        GEO_CONTINENT_CODE = 'geo.continent.code'
    
        # Two-letter ISO Country Code ([ISO 3166-1 alpha2](https://wikipedia.org/wiki/ISO_3166-1#Codes)).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   CA
        #
        GEO_COUNTRY_ISO_CODE = 'geo.country.iso_code'
    
        # Locality name. Represents the name of a city, town, village, or similar populated place.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Montreal
        #   Berlin
        #
        GEO_LOCALITY_NAME = 'geo.locality.name'
    
        # Latitude of the geo location in [WGS84](https://wikipedia.org/wiki/World_Geodetic_System#WGS84).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   45.505918
        #
        GEO_LOCATION_LAT = 'geo.location.lat'
    
        # Longitude of the geo location in [WGS84](https://wikipedia.org/wiki/World_Geodetic_System#WGS84).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   -73.61483
        #
        GEO_LOCATION_LON = 'geo.location.lon'
    
        # Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   94040
        #
        GEO_POSTAL_CODE = 'geo.postal_code'
    
        # Region ISO code ([ISO 3166-2](https://wikipedia.org/wiki/ISO_3166-2)).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   CA-QC
        #
        GEO_REGION_ISO_CODE = 'geo.region.iso_code'
    
        # @!endgroup
      end
    end
  end
end