# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module GEN_AI
        # @!group Attribute Names
      
        # Free-form description of the GenAI agent provided by the application.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Helps with math problems
        #   Generates fiction stories
        #
        GEN_AI_AGENT_DESCRIPTION = 'gen_ai.agent.description'
    
        # The unique identifier of the GenAI agent.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   asst_5j66UpCpwteGg4YSxUnt7lPY
        #
        GEN_AI_AGENT_ID = 'gen_ai.agent.id'
    
        # Human-readable name of the GenAI agent provided by the application.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Math Tutor
        #   Fiction Writer
        #
        GEN_AI_AGENT_NAME = 'gen_ai.agent.name'
    
        # Deprecated, use Event API to report completions contents.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   [{'role': 'assistant', 'content': 'The capital of France is Paris.'}]
        #
        # @deprecated {"note": "Removed, no replacement at this time.", "reason": "obsoleted"}
        GEN_AI_COMPLETION = 'gen_ai.completion'
    
        # The unique identifier for a conversation (session, thread), used to store and correlate messages within this conversation.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   conv_5j66UpCpwteGg4YSxUnt7lPY
        #
        GEN_AI_CONVERSATION_ID = 'gen_ai.conversation.id'
    
        # The data source identifier.
        #
        # Data sources are used by AI agents and RAG applications to store grounding data. A data source may be an external database, object store, document collection, website, or any other storage system used by the GenAI agent or application. The `gen_ai.data_source.id` SHOULD match the identifier used by the GenAI system rather than a name specific to the external storage, such as a database or object store. Semantic conventions referencing `gen_ai.data_source.id` MAY also leverage additional attributes, such as `db.*`, to further identify and describe the data source.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   H7STPQYOND
        #
        GEN_AI_DATA_SOURCE_ID = 'gen_ai.data_source.id'
    
        # Deprecated, use `gen_ai.output.type`.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Replaced by `gen_ai.output.type`.", "reason": "renamed", "renamed_to": "gen_ai.output.type"}
        GEN_AI_OPENAI_REQUEST_RESPONSE_FORMAT = 'gen_ai.openai.request.response_format'
    
        # Deprecated, use `gen_ai.request.seed`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   100
        #
        # @deprecated {"note": "Replaced by `gen_ai.request.seed`.", "reason": "renamed", "renamed_to": "gen_ai.request.seed"}
        GEN_AI_OPENAI_REQUEST_SEED = 'gen_ai.openai.request.seed'
    
        # The service tier requested. May be a specific tier, default, or auto.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   auto
        #   default
        #
        GEN_AI_OPENAI_REQUEST_SERVICE_TIER = 'gen_ai.openai.request.service_tier'
    
        # The service tier used for the response.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   scale
        #   default
        #
        GEN_AI_OPENAI_RESPONSE_SERVICE_TIER = 'gen_ai.openai.response.service_tier'
    
        # A fingerprint to track any eventual change in the Generative AI environment.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   fp_44709d6fcb
        #
        GEN_AI_OPENAI_RESPONSE_SYSTEM_FINGERPRINT = 'gen_ai.openai.response.system_fingerprint'
    
        # The name of the operation being performed.
        #
        # If one of the predefined values applies, but specific system uses a different name it's RECOMMENDED to document it in the semantic conventions for specific GenAI system and use system-specific name in the instrumentation. If a different name is not documented, instrumentation libraries SHOULD use applicable predefined value.
        #
        # @note Stability Level: development
        GEN_AI_OPERATION_NAME = 'gen_ai.operation.name'
    
        # Represents the content type requested by the client.
        #
        # This attribute SHOULD be used when the client requests output of a specific type. The model may return zero or more outputs of this type.
        # This attribute specifies the output modality and not the actual output format. For example, if an image is requested, the actual output could be a URL pointing to an image file.
        # Additional output format details may be recorded in the future in the `gen_ai.output.{type}.*` attributes.
        #
        # @note Stability Level: development
        GEN_AI_OUTPUT_TYPE = 'gen_ai.output.type'
    
        # Deprecated, use Event API to report prompt contents.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   [{'role': 'user', 'content': 'What is the capital of France?'}]
        #
        # @deprecated {"note": "Removed, no replacement at this time.", "reason": "obsoleted"}
        GEN_AI_PROMPT = 'gen_ai.prompt'
    
        # The target number of candidate completions to return.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   3
        #
        GEN_AI_REQUEST_CHOICE_COUNT = 'gen_ai.request.choice.count'
    
        # The encoding formats requested in an embeddings operation, if specified.
        #
        # In some GenAI systems the encoding formats are called embedding types. Also, some GenAI systems only accept a single format per request.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["base64"]
        #   ["float", "binary"]
        #
        GEN_AI_REQUEST_ENCODING_FORMATS = 'gen_ai.request.encoding_formats'
    
        # The frequency penalty setting for the GenAI request.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0.1
        #
        GEN_AI_REQUEST_FREQUENCY_PENALTY = 'gen_ai.request.frequency_penalty'
    
        # The maximum number of tokens the model generates for a request.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   100
        #
        GEN_AI_REQUEST_MAX_TOKENS = 'gen_ai.request.max_tokens'
    
        # The name of the GenAI model a request is being made to.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   gpt-4
        #
        GEN_AI_REQUEST_MODEL = 'gen_ai.request.model'
    
        # The presence penalty setting for the GenAI request.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0.1
        #
        GEN_AI_REQUEST_PRESENCE_PENALTY = 'gen_ai.request.presence_penalty'
    
        # Requests with same seed value more likely to return same result.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   100
        #
        GEN_AI_REQUEST_SEED = 'gen_ai.request.seed'
    
        # List of sequences that the model will use to stop generating further tokens.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["forest", "lived"]
        #
        GEN_AI_REQUEST_STOP_SEQUENCES = 'gen_ai.request.stop_sequences'
    
        # The temperature setting for the GenAI request.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0.0
        #
        GEN_AI_REQUEST_TEMPERATURE = 'gen_ai.request.temperature'
    
        # The top_k sampling setting for the GenAI request.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1.0
        #
        GEN_AI_REQUEST_TOP_K = 'gen_ai.request.top_k'
    
        # The top_p sampling setting for the GenAI request.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1.0
        #
        GEN_AI_REQUEST_TOP_P = 'gen_ai.request.top_p'
    
        # Array of reasons the model stopped generating tokens, corresponding to each generation received.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["stop"]
        #   ["stop", "length"]
        #
        GEN_AI_RESPONSE_FINISH_REASONS = 'gen_ai.response.finish_reasons'
    
        # The unique identifier for the completion.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   chatcmpl-123
        #
        GEN_AI_RESPONSE_ID = 'gen_ai.response.id'
    
        # The name of the model that generated the response.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   gpt-4-0613
        #
        GEN_AI_RESPONSE_MODEL = 'gen_ai.response.model'
    
        # The Generative AI product as identified by the client or server instrumentation.
        #
        # The `gen_ai.system` describes a family of GenAI models with specific model identified
        # by `gen_ai.request.model` and `gen_ai.response.model` attributes.
        #
        # The actual GenAI product may differ from the one identified by the client.
        # Multiple systems, including Azure OpenAI and Gemini, are accessible by OpenAI client
        # libraries. In such cases, the `gen_ai.system` is set to `openai` based on the
        # instrumentation's best knowledge, instead of the actual system. The `server.address`
        # attribute may help identify the actual system in use for `openai`.
        #
        # For custom model, a custom friendly name SHOULD be used.
        # If none of these options apply, the `gen_ai.system` SHOULD be set to `_OTHER`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   openai
        #
        GEN_AI_SYSTEM = 'gen_ai.system'
    
        # The type of token being counted.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   input
        #   output
        #
        GEN_AI_TOKEN_TYPE = 'gen_ai.token.type'
    
        # The tool call identifier.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   call_mszuSIzqtI65i1wAUOE8w5H4
        #
        GEN_AI_TOOL_CALL_ID = 'gen_ai.tool.call.id'
    
        # The tool description.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Multiply two numbers
        #
        GEN_AI_TOOL_DESCRIPTION = 'gen_ai.tool.description'
    
        # Name of the tool utilized by the agent.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Flights
        #
        GEN_AI_TOOL_NAME = 'gen_ai.tool.name'
    
        # Type of the tool utilized by the agent
        #
        # Extension: A tool executed on the agent-side to directly call external APIs, bridging the gap between the agent and real-world systems.
        # Agent-side operations involve actions that are performed by the agent on the server or within the agent's controlled environment.
        # Function: A tool executed on the client-side, where the agent generates parameters for a predefined function, and the client executes the logic.
        # Client-side operations are actions taken on the user's end or within the client application.
        # Datastore: A tool used by the agent to access and query structured or unstructured external data for retrieval-augmented tasks or knowledge updates.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   function
        #   extension
        #   datastore
        #
        GEN_AI_TOOL_TYPE = 'gen_ai.tool.type'
    
        # Deprecated, use `gen_ai.usage.output_tokens` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   42
        #
        # @deprecated {"note": "Replaced by `gen_ai.usage.output_tokens`.", "reason": "renamed", "renamed_to": "gen_ai.usage.output_tokens"}
        GEN_AI_USAGE_COMPLETION_TOKENS = 'gen_ai.usage.completion_tokens'
    
        # The number of tokens used in the GenAI input (prompt).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   100
        #
        GEN_AI_USAGE_INPUT_TOKENS = 'gen_ai.usage.input_tokens'
    
        # The number of tokens used in the GenAI response (completion).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   180
        #
        GEN_AI_USAGE_OUTPUT_TOKENS = 'gen_ai.usage.output_tokens'
    
        # Deprecated, use `gen_ai.usage.input_tokens` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   42
        #
        # @deprecated {"note": "Replaced by `gen_ai.usage.input_tokens`.", "reason": "renamed", "renamed_to": "gen_ai.usage.input_tokens"}
        GEN_AI_USAGE_PROMPT_TOKENS = 'gen_ai.usage.prompt_tokens'
    
        # @!endgroup
      end
    end
  end
end