# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module FAAS
        # @!group Attribute Names
      
        # A boolean that is true if the serverless function is executed for the first time (aka cold-start).
        #
        # @note Stability Level: development
        FAAS_COLDSTART = 'faas.coldstart'
    
        # A string containing the schedule period as [Cron Expression](https://docs.oracle.com/cd/E12058_01/doc/doc.1014/e12030/cron_expressions.htm).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0/5 * * * ? *
        #
        FAAS_CRON = 'faas.cron'
    
        # The name of the source on which the triggering operation was performed. For example, in Cloud Storage or S3 corresponds to the bucket name, and in Cosmos DB to the database name.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   myBucketName
        #   myDbName
        #
        FAAS_DOCUMENT_COLLECTION = 'faas.document.collection'
    
        # The document name/table subjected to the operation. For example, in Cloud Storage or S3 is the name of the file, and in Cosmos DB the table name.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   myFile.txt
        #   myTableName
        #
        FAAS_DOCUMENT_NAME = 'faas.document.name'
    
        # Describes the type of the operation that was performed on the data.
        #
        # @note Stability Level: development
        FAAS_DOCUMENT_OPERATION = 'faas.document.operation'
    
        # A string containing the time when the data was accessed in the [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format expressed in [UTC](https://www.w3.org/TR/NOTE-datetime).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   2020-01-23T13:47:06Z
        #
        FAAS_DOCUMENT_TIME = 'faas.document.time'
    
        # The execution environment ID as a string, that will be potentially reused for other invocations to the same function/function version.
        #
        # - **AWS Lambda:** Use the (full) log stream name.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   2021/06/28/[$LATEST]2f399eb14537447da05ab2a2e39309de
        #
        FAAS_INSTANCE = 'faas.instance'
    
        # The invocation ID of the current function invocation.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   af9d5aa4-a685-4c5f-a22b-444f80b3cc28
        #
        FAAS_INVOCATION_ID = 'faas.invocation_id'
    
        # The name of the invoked function.
        #
        # SHOULD be equal to the `faas.name` resource attribute of the invoked function.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   my-function
        #
        FAAS_INVOKED_NAME = 'faas.invoked_name'
    
        # The cloud provider of the invoked function.
        #
        # SHOULD be equal to the `cloud.provider` resource attribute of the invoked function.
        #
        # @note Stability Level: development
        FAAS_INVOKED_PROVIDER = 'faas.invoked_provider'
    
        # The cloud region of the invoked function.
        #
        # SHOULD be equal to the `cloud.region` resource attribute of the invoked function.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   eu-central-1
        #
        FAAS_INVOKED_REGION = 'faas.invoked_region'
    
        # The amount of memory available to the serverless function converted to Bytes.
        #
        # It's recommended to set this attribute since e.g. too little memory can easily stop a Java AWS Lambda function from working correctly. On AWS Lambda, the environment variable `AWS_LAMBDA_FUNCTION_MEMORY_SIZE` provides this information (which must be multiplied by 1,048,576).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   134217728
        #
        FAAS_MAX_MEMORY = 'faas.max_memory'
    
        # The name of the single function that this runtime instance executes.
        #
        # This is the name of the function as configured/deployed on the FaaS
        # platform and is usually different from the name of the callback
        # function (which may be stored in the
        # [`code.namespace`/`code.function.name`](/docs/general/attributes.md#source-code-attributes)
        # span attributes).
        #
        # For some cloud providers, the above definition is ambiguous. The following
        # definition of function name MUST be used for this attribute
        # (and consequently the span name) for the listed cloud providers/products:
        #
        # - **Azure:**  The full name `<FUNCAPP>/<FUNC>`, i.e., function app name
        #   followed by a forward slash followed by the function name (this form
        #   can also be seen in the resource JSON for the function).
        #   This means that a span attribute MUST be used, as an Azure function
        #   app can host multiple functions that would usually share
        #   a TracerProvider (see also the `cloud.resource_id` attribute).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   my-function
        #   myazurefunctionapp/some-function-name
        #
        FAAS_NAME = 'faas.name'
    
        # A string containing the function invocation time in the [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format expressed in [UTC](https://www.w3.org/TR/NOTE-datetime).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   2020-01-23T13:47:06Z
        #
        FAAS_TIME = 'faas.time'
    
        # Type of the trigger which caused this function invocation.
        #
        # @note Stability Level: development
        FAAS_TRIGGER = 'faas.trigger'
    
        # The immutable version of the function being executed.
        #
        # Depending on the cloud provider and platform, use:
        #
        # - **AWS Lambda:** The [function version](https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html)
        #   (an integer represented as a decimal string).
        # - **Google Cloud Run (Services):** The [revision](https://cloud.google.com/run/docs/managing/revisions)
        #   (i.e., the function name plus the revision suffix).
        # - **Google Cloud Functions:** The value of the
        #   [`K_REVISION` environment variable](https://cloud.google.com/functions/docs/env-var#runtime_environment_variables_set_automatically).
        # - **Azure Functions:** Not applicable. Do not set this attribute.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   26
        #   pinkfroid-00002
        #
        FAAS_VERSION = 'faas.version'
    
        # @!endgroup
      end
    end
  end
end