# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module DEPLOYMENT
        # @!group Attribute Names
      
        # 'Deprecated, use `deployment.environment.name` instead.'
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   staging
        #   production
        #
        # @deprecated {"note": "Replaced by `deployment.environment.name`.", "reason": "renamed", "renamed_to": "deployment.environment.name"}
        DEPLOYMENT_ENVIRONMENT = 'deployment.environment'
    
        # Name of the [deployment environment](https://wikipedia.org/wiki/Deployment_environment) (aka deployment tier).
        #
        # `deployment.environment.name` does not affect the uniqueness constraints defined through
        # the `service.namespace`, `service.name` and `service.instance.id` resource attributes.
        # This implies that resources carrying the following attribute combinations MUST be
        # considered to be identifying the same service:
        #
        # - `service.name=frontend`, `deployment.environment.name=production`
        # - `service.name=frontend`, `deployment.environment.name=staging`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   staging
        #   production
        #
        DEPLOYMENT_ENVIRONMENT_NAME = 'deployment.environment.name'
    
        # The id of the deployment.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1208
        #
        DEPLOYMENT_ID = 'deployment.id'
    
        # The name of the deployment.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   deploy my app
        #   deploy-frontend
        #
        DEPLOYMENT_NAME = 'deployment.name'
    
        # The status of the deployment.
        #
        # @note Stability Level: development
        DEPLOYMENT_STATUS = 'deployment.status'
    
        # @!endgroup
      end
    end
  end
end