# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module CPYTHON
        # @!group Metrics Names
      
        # The total number of objects collected inside a generation since interpreter start.
        #
        # This metric reports data from [`gc.stats()`](https://docs.python.org/3/library/gc.html#gc.get_stats).
        #
        # @note Stability Level: development
        CPYTHON_GC_COLLECTED_OBJECTS = 'cpython.gc.collected_objects'
    
        # The number of times a generation was collected since interpreter start.
        #
        # This metric reports data from [`gc.stats()`](https://docs.python.org/3/library/gc.html#gc.get_stats).
        #
        # @note Stability Level: development
        CPYTHON_GC_COLLECTIONS = 'cpython.gc.collections'
    
        # The total number of objects which were found to be uncollectable inside a generation since interpreter start.
        #
        # This metric reports data from [`gc.stats()`](https://docs.python.org/3/library/gc.html#gc.get_stats).
        #
        # @note Stability Level: development
        CPYTHON_GC_UNCOLLECTABLE_OBJECTS = 'cpython.gc.uncollectable_objects'
    
        # @!endgroup
      end
    end
  end
end