# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module CONTAINER
        # @!group Metrics Names
      
        # Total CPU time consumed
        #
        # Total CPU time consumed by the specific container on all available CPU cores
        #
        # @note Stability Level: development
        CONTAINER_CPU_TIME = 'container.cpu.time'
    
        # Container's CPU usage, measured in cpus. Range from 0 to the number of allocatable CPUs
        #
        # CPU usage of the specific container on all available CPU cores, averaged over the sample window
        #
        # @note Stability Level: development
        CONTAINER_CPU_USAGE = 'container.cpu.usage'
    
        # Disk bytes for the container.
        #
        # The total number of bytes read/written successfully (aggregated from all disks).
        #
        # @note Stability Level: development
        CONTAINER_DISK_IO = 'container.disk.io'
    
        # Memory usage of the container.
        #
        # Memory usage of the container.
        #
        # @note Stability Level: development
        CONTAINER_MEMORY_USAGE = 'container.memory.usage'
    
        # Network bytes for the container.
        #
        # The number of bytes sent/received on all network interfaces by the container.
        #
        # @note Stability Level: development
        CONTAINER_NETWORK_IO = 'container.network.io'
    
        # The time the container has been running
        #
        # Instrumentations SHOULD use a gauge with type `double` and measure uptime in seconds as a floating point number with the highest precision available.
        # The actual accuracy would depend on the instrumentation and operating system.
        #
        # @note Stability Level: development
        CONTAINER_UPTIME = 'container.uptime'
    
        # @!endgroup
      end
    end
  end
end