# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module CONTAINER
        # @!group Attribute Names
      
        # The command used to run the container (i.e. the command name).
        #
        # If using embedded credentials or sensitive data, it is recommended to remove them to prevent potential leakage.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   otelcontribcol
        #
        CONTAINER_COMMAND = 'container.command'
    
        # All the command arguments (including the command/executable itself) run by the container.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["otelcontribcol", "--config", "config.yaml"]
        #
        CONTAINER_COMMAND_ARGS = 'container.command_args'
    
        # The full command run by the container as a single string representing the full command.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   otelcontribcol --config config.yaml
        #
        CONTAINER_COMMAND_LINE = 'container.command_line'
    
        # Deprecated, use `cpu.mode` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   user
        #   kernel
        #
        # @deprecated {"note": "Replaced by `cpu.mode`.", "reason": "renamed", "renamed_to": "cpu.mode"}
        CONTAINER_CPU_STATE = 'container.cpu.state'
    
        # The name of the CSI ([Container Storage Interface](https://github.com/container-storage-interface/spec)) plugin used by the volume.
        #
        # This can sometimes be referred to as a "driver" in CSI implementations. This should represent the `name` field of the GetPluginInfo RPC.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   pd.csi.storage.gke.io
        #
        CONTAINER_CSI_PLUGIN_NAME = 'container.csi.plugin.name'
    
        # The unique volume ID returned by the CSI ([Container Storage Interface](https://github.com/container-storage-interface/spec)) plugin.
        #
        # This can sometimes be referred to as a "volume handle" in CSI implementations. This should represent the `Volume.volume_id` field in CSI spec.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   projects/my-gcp-project/zones/my-gcp-zone/disks/my-gcp-disk
        #
        CONTAINER_CSI_VOLUME_ID = 'container.csi.volume.id'
    
        # Container ID. Usually a UUID, as for example used to [identify Docker containers](https://docs.docker.com/engine/containers/run/#container-identification). The UUID might be abbreviated.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   a3bf90e006b2
        #
        CONTAINER_ID = 'container.id'
    
        # Runtime specific image identifier. Usually a hash algorithm followed by a UUID.
        #
        # Docker defines a sha256 of the image id; `container.image.id` corresponds to the `Image` field from the Docker container inspect [API](https://docs.docker.com/engine/api/v1.43/#tag/Container/operation/ContainerInspect) endpoint.
        # K8s defines a link to the container registry repository with digest `"imageID": "registry.azurecr.io /namespace/service/dockerfile@sha256:bdeabd40c3a8a492eaf9e8e44d0ebbb84bac7ee25ac0cf8a7159d25f62555625"`.
        # The ID is assigned by the container runtime and can vary in different environments. Consider using `oci.manifest.digest` if it is important to identify the same image in different environments/runtimes.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   sha256:19c92d0a00d1b66d897bceaa7319bee0dd38a10a851c60bcec9474aa3f01e50f
        #
        CONTAINER_IMAGE_ID = 'container.image.id'
    
        # Name of the image the container was built on.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   gcr.io/opentelemetry/operator
        #
        CONTAINER_IMAGE_NAME = 'container.image.name'
    
        # Repo digests of the container image as provided by the container runtime.
        #
        # [Docker](https://docs.docker.com/engine/api/v1.43/#tag/Image/operation/ImageInspect) and [CRI](https://github.com/kubernetes/cri-api/blob/c75ef5b473bbe2d0a4fc92f82235efd665ea8e9f/pkg/apis/runtime/v1/api.proto#L1237-L1238) report those under the `RepoDigests` field.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["example@sha256:afcc7f1ac1b49db317a7196c902e61c6c3c4607d63599ee1a82d702d249a0ccb", "internal.registry.example.com:5000/example@sha256:b69959407d21e8a062e0416bf13405bb2b71ed7a84dde4158ebafacfa06f5578"]
        #
        CONTAINER_IMAGE_REPO_DIGESTS = 'container.image.repo_digests'
    
        # Container image tags. An example can be found in [Docker Image Inspect](https://docs.docker.com/engine/api/v1.43/#tag/Image/operation/ImageInspect). Should be only the `<tag>` section of the full name for example from `registry.example.com/my-org/my-image:<tag>`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["v1.27.1", "3.5.7-0"]
        #
        CONTAINER_IMAGE_TAGS = 'container.image.tags'
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   CONTAINER_LABEL_LAMBDA.call('some-cool-key') #=> 'container.label.some-cool-key'
        #
        # Container labels, `<key>` being the label name, the value being the label value.
        #
        # For example, a docker container label `app` with value `nginx` SHOULD be recorded as the `container.label.app` attribute with value `"nginx"`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   nginx
        #
        CONTAINER_LABEL_LAMBDA = ->(key) { "container.label.#{key}" }
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   CONTAINER_LABELS_LAMBDA.call('some-cool-key') #=> 'container.labels.some-cool-key'
        #
        # Deprecated, use `container.label` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   nginx
        #
        # @deprecated {"note": "Replaced by `container.label`.", "reason": "renamed", "renamed_to": "container.label"}
        CONTAINER_LABELS_LAMBDA = ->(key) { "container.labels.#{key}" }
    
        # Container name used by container runtime.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   opentelemetry-autoconf
        #
        CONTAINER_NAME = 'container.name'
    
        # The container runtime managing this container.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   docker
        #   containerd
        #   rkt
        #
        CONTAINER_RUNTIME = 'container.runtime'
    
        # @!endgroup
      end
    end
  end
end