# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module CLOUDFOUNDRY
        # @!group Attribute Names
      
        # The guid of the application.
        #
        # Application instrumentation should use the value from environment
        # variable `VCAP_APPLICATION.application_id`. This is the same value as
        # reported by `cf app <app-name> --guid`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   218fc5a9-a5f1-4b54-aa05-46717d0ab26d
        #
        CLOUDFOUNDRY_APP_ID = 'cloudfoundry.app.id'
    
        # The index of the application instance. 0 when just one instance is active.
        #
        # CloudFoundry defines the `instance_id` in the [Loggregator v2 envelope](https://github.com/cloudfoundry/loggregator-api#v2-envelope).
        # It is used for logs and metrics emitted by CloudFoundry. It is
        # supposed to contain the application instance index for applications
        # deployed on the runtime.
        #
        # Application instrumentation should use the value from environment
        # variable `CF_INSTANCE_INDEX`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0
        #   1
        #
        CLOUDFOUNDRY_APP_INSTANCE_ID = 'cloudfoundry.app.instance.id'
    
        # The name of the application.
        #
        # Application instrumentation should use the value from environment
        # variable `VCAP_APPLICATION.application_name`. This is the same value
        # as reported by `cf apps`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   my-app-name
        #
        CLOUDFOUNDRY_APP_NAME = 'cloudfoundry.app.name'
    
        # The guid of the CloudFoundry org the application is running in.
        #
        # Application instrumentation should use the value from environment
        # variable `VCAP_APPLICATION.org_id`. This is the same value as
        # reported by `cf org <org-name> --guid`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   218fc5a9-a5f1-4b54-aa05-46717d0ab26d
        #
        CLOUDFOUNDRY_ORG_ID = 'cloudfoundry.org.id'
    
        # The name of the CloudFoundry organization the app is running in.
        #
        # Application instrumentation should use the value from environment
        # variable `VCAP_APPLICATION.org_name`. This is the same value as
        # reported by `cf orgs`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   my-org-name
        #
        CLOUDFOUNDRY_ORG_NAME = 'cloudfoundry.org.name'
    
        # The UID identifying the process.
        #
        # Application instrumentation should use the value from environment
        # variable `VCAP_APPLICATION.process_id`. It is supposed to be equal to
        # `VCAP_APPLICATION.app_id` for applications deployed to the runtime.
        # For system components, this could be the actual PID.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   218fc5a9-a5f1-4b54-aa05-46717d0ab26d
        #
        CLOUDFOUNDRY_PROCESS_ID = 'cloudfoundry.process.id'
    
        # The type of process.
        #
        # CloudFoundry applications can consist of multiple jobs. Usually the
        # main process will be of type `web`. There can be additional background
        # tasks or side-cars with different process types.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   web
        #
        CLOUDFOUNDRY_PROCESS_TYPE = 'cloudfoundry.process.type'
    
        # The guid of the CloudFoundry space the application is running in.
        #
        # Application instrumentation should use the value from environment
        # variable `VCAP_APPLICATION.space_id`. This is the same value as
        # reported by `cf space <space-name> --guid`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   218fc5a9-a5f1-4b54-aa05-46717d0ab26d
        #
        CLOUDFOUNDRY_SPACE_ID = 'cloudfoundry.space.id'
    
        # The name of the CloudFoundry space the application is running in.
        #
        # Application instrumentation should use the value from environment
        # variable `VCAP_APPLICATION.space_name`. This is the same value as
        # reported by `cf spaces`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   my-space-name
        #
        CLOUDFOUNDRY_SPACE_NAME = 'cloudfoundry.space.name'
    
        # A guid or another name describing the event source.
        #
        # CloudFoundry defines the `source_id` in the [Loggregator v2 envelope](https://github.com/cloudfoundry/loggregator-api#v2-envelope).
        # It is used for logs and metrics emitted by CloudFoundry. It is
        # supposed to contain the component name, e.g. "gorouter", for
        # CloudFoundry components.
        #
        # When system components are instrumented, values from the
        # [Bosh spec](https://bosh.io/docs/jobs/#properties-spec)
        # should be used. The `system.id` should be set to
        # `spec.deployment/spec.name`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   cf/gorouter
        #
        CLOUDFOUNDRY_SYSTEM_ID = 'cloudfoundry.system.id'
    
        # A guid describing the concrete instance of the event source.
        #
        # CloudFoundry defines the `instance_id` in the [Loggregator v2 envelope](https://github.com/cloudfoundry/loggregator-api#v2-envelope).
        # It is used for logs and metrics emitted by CloudFoundry. It is
        # supposed to contain the vm id for CloudFoundry components.
        #
        # When system components are instrumented, values from the
        # [Bosh spec](https://bosh.io/docs/jobs/#properties-spec)
        # should be used. The `system.instance.id` should be set to `spec.id`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   218fc5a9-a5f1-4b54-aa05-46717d0ab26d
        #
        CLOUDFOUNDRY_SYSTEM_INSTANCE_ID = 'cloudfoundry.system.instance.id'
    
        # @!endgroup
      end
    end
  end
end