# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module CLOUDEVENTS
        # @!group Attribute Names
      
        # The [event_id](https://github.com/cloudevents/spec/blob/v1.0.2/cloudevents/spec.md#id) uniquely identifies the event.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   123e4567-e89b-12d3-a456-426614174000
        #   0001
        #
        CLOUDEVENTS_EVENT_ID = 'cloudevents.event_id'
    
        # The [source](https://github.com/cloudevents/spec/blob/v1.0.2/cloudevents/spec.md#source-1) identifies the context in which an event happened.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   https://github.com/cloudevents
        #   /cloudevents/spec/pull/123
        #   my-service
        #
        CLOUDEVENTS_EVENT_SOURCE = 'cloudevents.event_source'
    
        # The [version of the CloudEvents specification](https://github.com/cloudevents/spec/blob/v1.0.2/cloudevents/spec.md#specversion) which the event uses.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1.0
        #
        CLOUDEVENTS_EVENT_SPEC_VERSION = 'cloudevents.event_spec_version'
    
        # The [subject](https://github.com/cloudevents/spec/blob/v1.0.2/cloudevents/spec.md#subject) of the event in the context of the event producer (identified by source).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   mynewfile.jpg
        #
        CLOUDEVENTS_EVENT_SUBJECT = 'cloudevents.event_subject'
    
        # The [event_type](https://github.com/cloudevents/spec/blob/v1.0.2/cloudevents/spec.md#type) contains a value describing the type of event related to the originating occurrence.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   com.github.pull_request.opened
        #   com.example.object.deleted.v2
        #
        CLOUDEVENTS_EVENT_TYPE = 'cloudevents.event_type'
    
        # @!endgroup
      end
    end
  end
end