# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module CICD
        # @!group Metrics Names
      
        # The number of pipeline runs currently active in the system by state.
        #
        # @note Stability Level: development
        CICD_PIPELINE_RUN_ACTIVE = 'cicd.pipeline.run.active'
    
        # Duration of a pipeline run grouped by pipeline, state and result.
        #
        # @note Stability Level: development
        CICD_PIPELINE_RUN_DURATION = 'cicd.pipeline.run.duration'
    
        # The number of errors encountered in pipeline runs (eg. compile, test failures).
        #
        # There might be errors in a pipeline run that are non fatal (eg. they are suppressed) or in a parallel stage multiple stages could have a fatal error.
        # This means that this error count might not be the same as the count of metric `cicd.pipeline.run.duration` with run result `failure`.
        #
        # @note Stability Level: development
        CICD_PIPELINE_RUN_ERRORS = 'cicd.pipeline.run.errors'
    
        # The number of errors in a component of the CICD system (eg. controller, scheduler, agent).
        #
        # Errors in pipeline run execution are explicitly excluded. Ie a test failure is not counted in this metric.
        #
        # @note Stability Level: development
        CICD_SYSTEM_ERRORS = 'cicd.system.errors'
    
        # The number of workers on the CICD system by state.
        #
        # @note Stability Level: development
        CICD_WORKER_COUNT = 'cicd.worker.count'
    
        # @!endgroup
      end
    end
  end
end