# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module CICD
        # @!group Attribute Names
      
        # The kind of action a pipeline run is performing.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   BUILD
        #   RUN
        #   SYNC
        #
        CICD_PIPELINE_ACTION_NAME = 'cicd.pipeline.action.name'
    
        # The human readable name of the pipeline within a CI/CD system.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Build and Test
        #   Lint
        #   Deploy Go Project
        #   deploy_to_environment
        #
        CICD_PIPELINE_NAME = 'cicd.pipeline.name'
    
        # The result of a pipeline run.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   success
        #   failure
        #   timeout
        #   skipped
        #
        CICD_PIPELINE_RESULT = 'cicd.pipeline.result'
    
        # The unique identifier of a pipeline run within a CI/CD system.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   120912
        #
        CICD_PIPELINE_RUN_ID = 'cicd.pipeline.run.id'
    
        # The pipeline run goes through these states during its lifecycle.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   pending
        #   executing
        #   finalizing
        #
        CICD_PIPELINE_RUN_STATE = 'cicd.pipeline.run.state'
    
        # The [URL](https://wikipedia.org/wiki/URL) of the pipeline run, providing the complete address in order to locate and identify the pipeline run.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   https://github.com/open-telemetry/semantic-conventions/actions/runs/9753949763?pr=1075
        #
        CICD_PIPELINE_RUN_URL_FULL = 'cicd.pipeline.run.url.full'
    
        # The human readable name of a task within a pipeline. Task here most closely aligns with a [computing process](https://wikipedia.org/wiki/Pipeline_(computing)) in a pipeline. Other terms for tasks include commands, steps, and procedures.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Run GoLang Linter
        #   Go Build
        #   go-test
        #   deploy_binary
        #
        CICD_PIPELINE_TASK_NAME = 'cicd.pipeline.task.name'
    
        # The unique identifier of a task run within a pipeline.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   12097
        #
        CICD_PIPELINE_TASK_RUN_ID = 'cicd.pipeline.task.run.id'
    
        # The result of a task run.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   success
        #   failure
        #   timeout
        #   skipped
        #
        CICD_PIPELINE_TASK_RUN_RESULT = 'cicd.pipeline.task.run.result'
    
        # The [URL](https://wikipedia.org/wiki/URL) of the pipeline task run, providing the complete address in order to locate and identify the pipeline task run.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   https://github.com/open-telemetry/semantic-conventions/actions/runs/9753949763/job/26920038674?pr=1075
        #
        CICD_PIPELINE_TASK_RUN_URL_FULL = 'cicd.pipeline.task.run.url.full'
    
        # The type of the task within a pipeline.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   build
        #   test
        #   deploy
        #
        CICD_PIPELINE_TASK_TYPE = 'cicd.pipeline.task.type'
    
        # The name of a component of the CICD system.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   controller
        #   scheduler
        #   agent
        #
        CICD_SYSTEM_COMPONENT = 'cicd.system.component'
    
        # The unique identifier of a worker within a CICD system.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   abc123
        #   10.0.1.2
        #   controller
        #
        CICD_WORKER_ID = 'cicd.worker.id'
    
        # The name of a worker within a CICD system.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   agent-abc
        #   controller
        #   Ubuntu LTS
        #
        CICD_WORKER_NAME = 'cicd.worker.name'
    
        # The state of a CICD worker / agent.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   idle
        #   busy
        #   down
        #
        CICD_WORKER_STATE = 'cicd.worker.state'
    
        # The [URL](https://wikipedia.org/wiki/URL) of the worker, providing the complete address in order to locate and identify the worker.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   https://cicd.example.org/worker/abc123
        #
        CICD_WORKER_URL_FULL = 'cicd.worker.url.full'
    
        # @!endgroup
      end
    end
  end
end