# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module APP
        # @!group Attribute Names
      
        # A unique identifier representing the installation of an application on a specific device
        #
        # Its value SHOULD persist across launches of the same application installation, including through application upgrades.
        # It SHOULD change if the application is uninstalled or if all applications of the vendor are uninstalled.
        # Additionally, users might be able to reset this value (e.g. by clearing application data).
        # If an app is installed multiple times on the same device (e.g. in different accounts on Android), each `app.installation.id` SHOULD have a different value.
        # If multiple OpenTelemetry SDKs are used within the same application, they SHOULD use the same value for `app.installation.id`.
        # Hardware IDs (e.g. serial number, IMEI, MAC address) MUST NOT be used as the `app.installation.id`.
        #
        # For iOS, this value SHOULD be equal to the [vendor identifier](https://developer.apple.com/documentation/uikit/uidevice/identifierforvendor).
        #
        # For Android, examples of `app.installation.id` implementations include:
        #
        # - [Firebase Installation ID](https://firebase.google.com/docs/projects/manage-installations).
        # - A globally unique UUID which is persisted across sessions in your application.
        # - [App set ID](https://developer.android.com/identity/app-set-id).
        # - [`Settings.getString(Settings.Secure.ANDROID_ID)`](https://developer.android.com/reference/android/provider/Settings.Secure#ANDROID_ID).
        #
        # More information about Android identifier best practices can be found [here](https://developer.android.com/training/articles/user-data-ids).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   2ab2916d-a51f-4ac8-80ee-45ac31a28092
        #
        APP_INSTALLATION_ID = 'app.installation.id'
    
        # The x (horizontal) coordinate of a screen coordinate, in screen pixels.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0
        #   131
        #
        APP_SCREEN_COORDINATE_X = 'app.screen.coordinate.x'
    
        # The y (vertical) component of a screen coordinate, in screen pixels.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   12
        #   99
        #
        APP_SCREEN_COORDINATE_Y = 'app.screen.coordinate.y'
    
        # An identifier that uniquely differentiates this widget from other widgets in the same application.
        #
        # A widget is an application component, typically an on-screen visual GUI element.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   f9bc787d-ff05-48ad-90e1-fca1d46130b3
        #   submit_order_1829
        #
        APP_WIDGET_ID = 'app.widget.id'
    
        # The name of an application widget.
        #
        # A widget is an application component, typically an on-screen visual GUI element.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   submit
        #   attack
        #   Clear Cart
        #
        APP_WIDGET_NAME = 'app.widget.name'
    
        # @!endgroup
      end
    end
  end
end