# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module HTTP
      # @!group Attribute Names
    
      # Must be called with a key for the full attribute name. See notes below about the expectations
      # for the state of the key.
      #
      # @example Usage
      #   HTTP_REQUEST_HEADER_LAMBDA.call('some-cool-key') #=> 'http.request.header.some-cool-key'
      #
      # HTTP request headers, `<key>` being the normalized HTTP Header name (lowercase), the value being the header values.
      #
      # Instrumentations SHOULD require an explicit configuration of which headers are to be captured.
      # Including all request headers can be a security risk - explicit configuration helps avoid leaking sensitive information.
      #
      # The `User-Agent` header is already captured in the `user_agent.original` attribute.
      # Users MAY explicitly configure instrumentations to capture them even though it is not recommended.
      #
      # The attribute value MUST consist of either multiple header values as an array of strings
      # or a single-item array containing a possibly comma-concatenated string, depending on the way
      # the HTTP library provides access to headers.
      #
      # Examples:
      #
      # - A header `Content-Type: application/json` SHOULD be recorded as the `http.request.header.content-type`
      #   attribute with value `["application/json"]`.
      # - A header `X-Forwarded-For: 1.2.3.4, 1.2.3.5` SHOULD be recorded as the `http.request.header.x-forwarded-for`
      #   attribute with value `["1.2.3.4", "1.2.3.5"]` or `["1.2.3.4, 1.2.3.5"]` depending on the HTTP library.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   ["application/json"]
      #   ["1.2.3.4", "1.2.3.5"]
      #
      HTTP_REQUEST_HEADER_LAMBDA = ->(key) { "http.request.header.#{key}" }
  
      # HTTP request method.
      #
      # HTTP request method value SHOULD be "known" to the instrumentation.
      # By default, this convention defines "known" methods as the ones listed in [RFC9110](https://www.rfc-editor.org/rfc/rfc9110.html#name-methods)
      # and the PATCH method defined in [RFC5789](https://www.rfc-editor.org/rfc/rfc5789.html).
      #
      # If the HTTP request method is not known to instrumentation, it MUST set the `http.request.method` attribute to `_OTHER`.
      #
      # If the HTTP instrumentation could end up converting valid HTTP request methods to `_OTHER`, then it MUST provide a way to override
      # the list of known HTTP methods. If this override is done via environment variable, then the environment variable MUST be named
      # OTEL_INSTRUMENTATION_HTTP_KNOWN_METHODS and support a comma-separated list of case-sensitive known HTTP methods
      # (this list MUST be a full override of the default known method, it is not a list of known methods in addition to the defaults).
      #
      # HTTP method names are case-sensitive and `http.request.method` attribute value MUST match a known HTTP method name exactly.
      # Instrumentations for specific web frameworks that consider HTTP methods to be case insensitive, SHOULD populate a canonical equivalent.
      # Tracing instrumentations that do so, MUST also set `http.request.method_original` to the original value.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   GET
      #   POST
      #   HEAD
      #
      HTTP_REQUEST_METHOD = 'http.request.method'
  
      # Original HTTP method sent by the client in the request line.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   GeT
      #   ACL
      #   foo
      #
      HTTP_REQUEST_METHOD_ORIGINAL = 'http.request.method_original'
  
      # The ordinal number of request resending attempt (for any reason, including redirects).
      #
      # The resend count SHOULD be updated each time an HTTP request gets resent by the client, regardless of what was the cause of the resending (e.g. redirection, authorization failure, 503 Server Unavailable, network issues, or any other).
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   3
      #
      HTTP_REQUEST_RESEND_COUNT = 'http.request.resend_count'
  
      # Must be called with a key for the full attribute name. See notes below about the expectations
      # for the state of the key.
      #
      # @example Usage
      #   HTTP_RESPONSE_HEADER_LAMBDA.call('some-cool-key') #=> 'http.response.header.some-cool-key'
      #
      # HTTP response headers, `<key>` being the normalized HTTP Header name (lowercase), the value being the header values.
      #
      # Instrumentations SHOULD require an explicit configuration of which headers are to be captured.
      # Including all response headers can be a security risk - explicit configuration helps avoid leaking sensitive information.
      #
      # Users MAY explicitly configure instrumentations to capture them even though it is not recommended.
      #
      # The attribute value MUST consist of either multiple header values as an array of strings
      # or a single-item array containing a possibly comma-concatenated string, depending on the way
      # the HTTP library provides access to headers.
      #
      # Examples:
      #
      # - A header `Content-Type: application/json` header SHOULD be recorded as the `http.request.response.content-type`
      #   attribute with value `["application/json"]`.
      # - A header `My-custom-header: abc, def` header SHOULD be recorded as the `http.response.header.my-custom-header`
      #   attribute with value `["abc", "def"]` or `["abc, def"]` depending on the HTTP library.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   ["application/json"]
      #   ["abc", "def"]
      #
      HTTP_RESPONSE_HEADER_LAMBDA = ->(key) { "http.response.header.#{key}" }
  
      # [HTTP response status code](https://tools.ietf.org/html/rfc7231#section-6).
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   200
      #
      HTTP_RESPONSE_STATUS_CODE = 'http.response.status_code'
  
      # The matched route, that is, the path template in the format used by the respective server framework.
      #
      # MUST NOT be populated when this is not supported by the HTTP server framework as the route attribute should have low-cardinality and the URI path can NOT substitute it.
      # SHOULD include the [application root](/docs/http/http-spans.md#http-server-definitions) if there is one.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   /users/:userID?
      #   {controller}/{action}/{id?}
      #
      HTTP_ROUTE = 'http.route'
  
      # @!endgroup
    end
  end
end