# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module DOTNET
      # @!group Metrics Names
    
      # The number of .NET assemblies that are currently loaded.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as calling [`AppDomain.CurrentDomain.GetAssemblies().Length`](https://learn.microsoft.com/dotnet/api/system.appdomain.getassemblies).
      #
      # @note Stability Level: stable
      DOTNET_ASSEMBLY_COUNT = 'dotnet.assembly.count'
  
      # The number of exceptions that have been thrown in managed code.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as counting calls to [`AppDomain.CurrentDomain.FirstChanceException`](https://learn.microsoft.com/dotnet/api/system.appdomain.firstchanceexception).
      #
      # @note Stability Level: stable
      DOTNET_EXCEPTIONS = 'dotnet.exceptions'
  
      # The number of garbage collections that have occurred since the process has started.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric uses the [`GC.CollectionCount(int generation)`](https://learn.microsoft.com/dotnet/api/system.gc.collectioncount) API to calculate exclusive collections per generation.
      #
      # @note Stability Level: stable
      DOTNET_GC_COLLECTIONS = 'dotnet.gc.collections'
  
      # The *approximate* number of bytes allocated on the managed GC heap since the process has started. The returned value does not include any native allocations.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as calling [`GC.GetTotalAllocatedBytes()`](https://learn.microsoft.com/dotnet/api/system.gc.gettotalallocatedbytes).
      #
      # @note Stability Level: stable
      DOTNET_GC_HEAP_TOTAL_ALLOCATED = 'dotnet.gc.heap.total_allocated'
  
      # The heap fragmentation, as observed during the latest garbage collection.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as calling [`GC.GetGCMemoryInfo().GenerationInfo.FragmentationAfterBytes`](https://learn.microsoft.com/dotnet/api/system.gcgenerationinfo.fragmentationafterbytes).
      #
      # @note Stability Level: stable
      DOTNET_GC_LAST_COLLECTION_HEAP_FRAGMENTATION_SIZE = 'dotnet.gc.last_collection.heap.fragmentation.size'
  
      # The managed GC heap size (including fragmentation), as observed during the latest garbage collection.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as calling [`GC.GetGCMemoryInfo().GenerationInfo.SizeAfterBytes`](https://learn.microsoft.com/dotnet/api/system.gcgenerationinfo.sizeafterbytes).
      #
      # @note Stability Level: stable
      DOTNET_GC_LAST_COLLECTION_HEAP_SIZE = 'dotnet.gc.last_collection.heap.size'
  
      # The amount of committed virtual memory in use by the .NET GC, as observed during the latest garbage collection.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as calling [`GC.GetGCMemoryInfo().TotalCommittedBytes`](https://learn.microsoft.com/dotnet/api/system.gcmemoryinfo.totalcommittedbytes). Committed virtual memory may be larger than the heap size because it includes both memory for storing existing objects (the heap size) and some extra memory that is ready to handle newly allocated objects in the future.
      #
      # @note Stability Level: stable
      DOTNET_GC_LAST_COLLECTION_MEMORY_COMMITTED_SIZE = 'dotnet.gc.last_collection.memory.committed_size'
  
      # The total amount of time paused in GC since the process has started.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as calling [`GC.GetTotalPauseDuration()`](https://learn.microsoft.com/dotnet/api/system.gc.gettotalpauseduration).
      #
      # @note Stability Level: stable
      DOTNET_GC_PAUSE_TIME = 'dotnet.gc.pause.time'
  
      # The amount of time the JIT compiler has spent compiling methods since the process has started.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as calling [`JitInfo.GetCompilationTime()`](https://learn.microsoft.com/dotnet/api/system.runtime.jitinfo.getcompilationtime).
      #
      # @note Stability Level: stable
      DOTNET_JIT_COMPILATION_TIME = 'dotnet.jit.compilation.time'
  
      # Count of bytes of intermediate language that have been compiled since the process has started.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as calling [`JitInfo.GetCompiledILBytes()`](https://learn.microsoft.com/dotnet/api/system.runtime.jitinfo.getcompiledilbytes).
      #
      # @note Stability Level: stable
      DOTNET_JIT_COMPILED_IL_SIZE = 'dotnet.jit.compiled_il.size'
  
      # The number of times the JIT compiler (re)compiled methods since the process has started.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as calling [`JitInfo.GetCompiledMethodCount()`](https://learn.microsoft.com/dotnet/api/system.runtime.jitinfo.getcompiledmethodcount).
      #
      # @note Stability Level: stable
      DOTNET_JIT_COMPILED_METHODS = 'dotnet.jit.compiled_methods'
  
      # The number of times there was contention when trying to acquire a monitor lock since the process has started.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as calling [`Monitor.LockContentionCount`](https://learn.microsoft.com/dotnet/api/system.threading.monitor.lockcontentioncount).
      #
      # @note Stability Level: stable
      DOTNET_MONITOR_LOCK_CONTENTIONS = 'dotnet.monitor.lock_contentions'
  
      # The number of processors available to the process.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as accessing [`Environment.ProcessorCount`](https://learn.microsoft.com/dotnet/api/system.environment.processorcount).
      #
      # @note Stability Level: stable
      DOTNET_PROCESS_CPU_COUNT = 'dotnet.process.cpu.count'
  
      # CPU time used by the process.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as accessing the corresponding processor time properties on [`System.Diagnostics.Process`](https://learn.microsoft.com/dotnet/api/system.diagnostics.process).
      #
      # @note Stability Level: stable
      DOTNET_PROCESS_CPU_TIME = 'dotnet.process.cpu.time'
  
      # The number of bytes of physical memory mapped to the process context.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as calling [`Environment.WorkingSet`](https://learn.microsoft.com/dotnet/api/system.environment.workingset).
      #
      # @note Stability Level: stable
      DOTNET_PROCESS_MEMORY_WORKING_SET = 'dotnet.process.memory.working_set'
  
      # The number of work items that are currently queued to be processed by the thread pool.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as calling [`ThreadPool.PendingWorkItemCount`](https://learn.microsoft.com/dotnet/api/system.threading.threadpool.pendingworkitemcount).
      #
      # @note Stability Level: stable
      DOTNET_THREAD_POOL_QUEUE_LENGTH = 'dotnet.thread_pool.queue.length'
  
      # The number of thread pool threads that currently exist.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as calling [`ThreadPool.ThreadCount`](https://learn.microsoft.com/dotnet/api/system.threading.threadpool.threadcount).
      #
      # @note Stability Level: stable
      DOTNET_THREAD_POOL_THREAD_COUNT = 'dotnet.thread_pool.thread.count'
  
      # The number of work items that the thread pool has completed since the process has started.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as calling [`ThreadPool.CompletedWorkItemCount`](https://learn.microsoft.com/dotnet/api/system.threading.threadpool.completedworkitemcount).
      #
      # @note Stability Level: stable
      DOTNET_THREAD_POOL_WORK_ITEM_COUNT = 'dotnet.thread_pool.work_item.count'
  
      # The number of timer instances that are currently active.
      #
      # Meter name: `System.Runtime`; Added in: .NET 9.0.
      # This metric reports the same values as calling [`Timer.ActiveCount`](https://learn.microsoft.com/dotnet/api/system.threading.timer.activecount).
      #
      # @note Stability Level: stable
      DOTNET_TIMER_COUNT = 'dotnet.timer.count'
  
      # @!endgroup
    end
  end
end