# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module CODE
      # @!group Attribute Names
    
      # The column number in `code.file.path` best representing the operation. It SHOULD point within the code unit named in `code.function.name`. This attribute MUST NOT be used on the Profile signal since the data is already captured in 'message Line'. This constraint is imposed to prevent redundancy and maintain data integrity.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   16
      #
      CODE_COLUMN_NUMBER = 'code.column.number'
  
      # The source code file name that identifies the code unit as uniquely as possible (preferably an absolute file path). This attribute MUST NOT be used on the Profile signal since the data is already captured in 'message Function'. This constraint is imposed to prevent redundancy and maintain data integrity.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   /usr/local/MyApplication/content_root/app/index.php
      #
      CODE_FILE_PATH = 'code.file.path'
  
      # The method or function fully-qualified name without arguments. The value should fit the natural representation of the language runtime, which is also likely the same used within `code.stacktrace` attribute value. This attribute MUST NOT be used on the Profile signal since the data is already captured in 'message Function'. This constraint is imposed to prevent redundancy and maintain data integrity.
      #
      # Values and format depends on each language runtime, thus it is impossible to provide an exhaustive list of examples.
      # The values are usually the same (or prefixes of) the ones found in native stack trace representation stored in
      # `code.stacktrace` without information on arguments.
      #
      # Examples:
      #
      # - Java method: `com.example.MyHttpService.serveRequest`
      # - Java anonymous class method: `com.mycompany.Main$1.myMethod`
      # - Java lambda method: `com.mycompany.Main$$Lambda/0x0000748ae4149c00.myMethod`
      # - PHP function: `GuzzleHttp\Client::transfer`
      # - Go function: `github.com/my/repo/pkg.foo.func5`
      # - Elixir: `OpenTelemetry.Ctx.new`
      # - Erlang: `opentelemetry_ctx:new`
      # - Rust: `playground::my_module::my_cool_func`
      # - C function: `fopen`
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   com.example.MyHttpService.serveRequest
      #   GuzzleHttp\Client::transfer
      #   fopen
      #
      CODE_FUNCTION_NAME = 'code.function.name'
  
      # The line number in `code.file.path` best representing the operation. It SHOULD point within the code unit named in `code.function.name`. This attribute MUST NOT be used on the Profile signal since the data is already captured in 'message Line'. This constraint is imposed to prevent redundancy and maintain data integrity.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   42
      #
      CODE_LINE_NUMBER = 'code.line.number'
  
      # A stacktrace as a string in the natural representation for the language runtime. The representation is identical to [`exception.stacktrace`](/docs/exceptions/exceptions-spans.md#stacktrace-representation). This attribute MUST NOT be used on the Profile signal since the data is already captured in 'message Location'. This constraint is imposed to prevent redundancy and maintain data integrity.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   at com.example.GenerateTrace.methodB(GenerateTrace.java:13)\n at com.example.GenerateTrace.methodA(GenerateTrace.java:9)\n at com.example.GenerateTrace.main(GenerateTrace.java:5)

      CODE_STACKTRACE = 'code.stacktrace'
  
      # @!endgroup
    end
  end
end