# frozen_string_literal: true

Fabricator(:webauthn_credential) do
  user_id { Fabricate(:user).id }
  external_id { Base64.urlsafe_encode64(SecureRandom.random_bytes(16)) }
  public_key { OpenSSL::PKey::EC.generate('prime256v1').public_key }
  nickname { sequence(:nickname) { |i| "USB Key number #{i}" } }
  sign_count 0
end
