// NOTICE: This file is generated by Rollup. To modify it,
// please instead edit the ESM counterpart and rebuild with Rollup (npm run build).
'use strict';

const process = require('node:process');
const cosmiconfig = require('cosmiconfig');
const FileCache = require('./utils/FileCache.cjs');
const augmentConfig = require('./augmentConfig.cjs');

const IS_TEST = process.env.NODE_ENV === 'test';
const STOP_DIR = IS_TEST ? process.cwd() : undefined;

/**
 * @type {import('stylelint').PublicApi['_createLinter']}
 */
function createStylelint(options = {}) {

	if (!options.quietDeprecationWarnings) {
		const { emitDeprecationWarning } = require('./utils/emitWarning.cjs');
		emitDeprecationWarning(
			'The CommonJS Node.js API is deprecated.',
			'COMMONJS_NODEJS_API',
			'See https://stylelint.io/migration-guide/to-16',
		);
	}

	const cwd = options.cwd || process.cwd();

	return {
		_options: { ...options, cwd },

		_extendExplorer: cosmiconfig.cosmiconfig('', {
			transform: augmentConfig.augmentConfigExtended(cwd),
			stopDir: STOP_DIR,
			searchStrategy: 'global', // for backward compatibility
		}),

		_specifiedConfigCache: new Map(),
		_postcssResultCache: new Map(),
		_fileCache: new FileCache(options.cacheLocation, options.cacheStrategy, cwd),
	};
}

module.exports = createStylelint;
