import type { NodePath } from '@babel/traverse';
export declare function resolveObjectToNameArray(objectPath: NodePath, raw?: boolean): string[] | null;
/**
 * Returns an ArrayExpression which contains all the keys resolved from an object
 *
 * Ignores setters in objects
 *
 * Returns null in case of
 *  unresolvable spreads
 *  computed identifier keys
 */
export default function resolveObjectKeysToArray(path: NodePath): string[] | null;
