import { R as RequestHandler, p as ResponseResolutionContext } from './HttpResponse-BbwAqLE_.js';
import '@mswjs/interceptors';
import './utils/internal/isIterable.js';
import './typeUtils.js';
import 'graphql';
import './utils/matching/matchRequestUrl.js';

/**
 * Finds a response for the given request instance
 * in the array of request handlers.
 * @param handlers The array of request handlers.
 * @param request The `Request` instance.
 * @param resolutionContext Request resolution options.
 * @returns {Response} A mocked response, if any.
 */
declare const getResponse: (handlers: Array<RequestHandler>, request: Request, resolutionContext?: ResponseResolutionContext) => Promise<Response | undefined>;

export { getResponse };
