import type { NonRootResult } from './result/NonRootResult.js'

export type VisitorKeys = {
  [P in NonRootResult as P['type']]: Array<keyof P>
}

export const visitorKeys: VisitorKeys = {
  JsdocTypeAny: [],
  JsdocTypeFunction: ['typeParameters', 'parameters', 'returnType'],
  JsdocTypeGeneric: ['left', 'elements'],
  JsdocTypeImport: ['element'],
  JsdocTypeIndexSignature: ['right'],
  JsdocTypeIntersection: ['elements'],
  JsdocTypeKeyof: ['element'],
  JsdocTypeKeyValue: ['right'],
  JsdocTypeMappedType: ['right'],
  JsdocTypeName: [],
  JsdocTypeNamePath: ['left', 'right'],
  JsdocTypeNotNullable: ['element'],
  JsdocTypeNull: [],
  JsdocTypeNullable: ['element'],
  JsdocTypeNumber: [],
  JsdocTypeObject: ['elements'],
  JsdocTypeObjectField: ['key', 'right'],
  JsdocTypeJsdocObjectField: ['left', 'right'],
  JsdocTypeOptional: ['element'],
  JsdocTypeParenthesis: ['element'],
  JsdocTypeSpecialNamePath: [],
  JsdocTypeStringValue: [],
  JsdocTypeSymbol: ['element'],
  JsdocTypeTuple: ['elements'],
  JsdocTypeTypeof: ['element'],
  JsdocTypeUndefined: [],
  JsdocTypeUnion: ['elements'],
  JsdocTypeUnknown: [],
  JsdocTypeVariadic: ['element'],
  JsdocTypeProperty: [],
  JsdocTypePredicate: ['left', 'right'],
  JsdocTypeAsserts: ['left', 'right'],
  JsdocTypeReadonlyArray: ['element'],
  JsdocTypeAssertsPlain: ['element'],
  JsdocTypeConditional: ['checksType', 'extendsType', 'trueType', 'falseType'],
  JsdocTypeTypeParameter: ['name', 'constraint', 'defaultValue'],
  JsdocTypeCallSignature: ['typeParameters', 'parameters', 'returnType'],
  JsdocTypeConstructorSignature: ['typeParameters', 'parameters', 'returnType'],
  JsdocTypeMethodSignature: ['typeParameters', 'parameters', 'returnType'],
  JsdocTypeIndexedAccessIndex: ['right'],
  JsdocTypeTemplateLiteral: ['interpolations'],
  JsdocTypeComputedProperty: ['value'],
  JsdocTypeComputedMethod: ['value', 'typeParameters', 'parameters', 'returnType']
}
