"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rule = exports.name = void 0;
const icu_messageformat_parser_1 = require("@formatjs/icu-messageformat-parser");
const context_compat_1 = require("../context-compat");
const util_1 = require("../util");
exports.name = 'no-invalid-icu';
function checkNode(context, node) {
    const settings = (0, util_1.getSettings)(context);
    const msgs = (0, util_1.extractMessages)(node, settings);
    if (!msgs.length) {
        return;
    }
    for (const [{ message: { defaultMessage }, messageNode, },] of msgs) {
        if (!defaultMessage || !messageNode) {
            continue;
        }
        try {
            (0, icu_messageformat_parser_1.parse)(defaultMessage, {
                ignoreTag: settings.ignoreTag,
            });
        }
        catch (e) {
            const msg = e instanceof Error ? e.message : e;
            context.report({
                node: messageNode,
                messageId: 'icuError',
                data: { message: `Error parsing ICU string: ${msg}` },
            });
        }
    }
}
exports.rule = {
    meta: {
        type: 'problem',
        docs: {
            description: `Make sure ICU messages are formatted correctly with no bad select statements, plurals, etc.`,
        },
        fixable: 'code',
        schema: [],
        messages: {
            icuError: 'Invalid ICU Message format: {{message}}',
        },
    },
    defaultOptions: [],
    create(context) {
        const callExpressionVisitor = (node) => checkNode(context, node);
        const parserServices = (0, context_compat_1.getParserServices)(context);
        //@ts-expect-error defineTemplateBodyVisitor exists in Vue parser
        if (parserServices?.defineTemplateBodyVisitor) {
            //@ts-expect-error
            return parserServices.defineTemplateBodyVisitor({
                CallExpression: callExpressionVisitor,
            }, {
                CallExpression: callExpressionVisitor,
            });
        }
        return {
            JSXOpeningElement: (node) => checkNode(context, node),
            CallExpression: callExpressionVisitor,
        };
    },
};
