import type { CodePoint, Hexcode } from './types';
/**
 * This function will convert a hexadecimal codepoint to an array of numerical codepoints.
 * By default, it will split the hexcode using a dash, but can be customized with the 2nd argument.
 *
 * ```ts
 * import { fromHexcodeToCodepoint } from 'emojibase';
 *
 * fromHexcodeToCodepoint('270A-1F3FC'); // [9994, 127996]
 * fromHexcodeToCodepoint('270A 1F3FC', ' '); // [9994, 127996]
 * ```
 */
export declare function fromHexcodeToCodepoint(code: Hexcode, joiner?: string): CodePoint[];
//# sourceMappingURL=fromHexcodeToCodepoint.d.ts.map