import * as t from '@babel/types';
import { NodePath } from '@babel/core';
import { ExtractedMessageDescriptor, MessageDescriptor, MessageDescriptorPath, Options } from './types';
export declare function getMessageDescriptorKey(path: NodePath<any>): string;
export declare function createMessageDescriptor(propPaths: [
    NodePath<t.JSXIdentifier> | NodePath<t.Identifier>,
    NodePath<t.StringLiteral> | NodePath<t.JSXExpressionContainer>
][]): MessageDescriptorPath;
export declare function evaluateMessageDescriptor(descriptorPath: MessageDescriptorPath, isJSXSource: boolean | undefined, filename: string | undefined, idInterpolationPattern?: string, overrideIdFn?: Options['overrideIdFn'], preserveWhitespace?: Options['preserveWhitespace']): MessageDescriptor;
/**
 * Tag a node as extracted
 * Store this in the node itself so that multiple passes work. Specifically
 * if we remove `description` in the 1st pass, 2nd pass will fail since
 * it expect `description` to be there.
 * HACK: We store this in the node instance since this persists across
 * multiple plugin runs
 * @param path
 */
export declare function tagAsExtracted(path: NodePath<any>): void;
/**
 * Check if a node was extracted
 * @param path
 */
export declare function wasExtracted(path: NodePath<any>): boolean;
/**
 * Store a message in our global messages
 * @param messageDescriptor
 * @param path
 * @param opts
 * @param filename
 * @param messages
 */
export declare function storeMessage({ id, description, defaultMessage }: MessageDescriptor, path: NodePath<any>, { extractSourceLocation }: Options, filename: string | undefined, messages: ExtractedMessageDescriptor[]): void;
