/**
 * Makes it so the left and right arrows change focus, ala Tab/Shift+Tab. This is mostly designed
 * for KaiOS devices.
 */
interface FocusTrapTest {
    (element: Element): boolean;
}
/**
 * Start listening for keyboard events. Attaches a listener to the window.
 */
declare function register(): void;
/**
 * Stop listening for keyboard events. Unattaches a listener to the window.
 */
declare function unregister(): void;
/**
 * Set a focus trap test to identify any focus traps in the DOM, i.e. a top-level DOM node that indicates the root
 * of a focus trap. Once this is set, if focus changes within the focus trap, then will not leave the focus trap.
 * @param test: the test function
 * @see https://w3c.github.io/aria-practices/examples/dialog-modal/dialog.html
 */
declare function setFocusTrapTest(test: FocusTrapTest): void;
export { register, unregister, setFocusTrapTest };
