# Installation
> `npm install --save @types/requestidlecallback`

# Summary
This package contains type definitions for requestidlecallback (https://w3c.github.io/requestidlecallback/).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/requestidlecallback.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/requestidlecallback/index.d.ts)
````ts
/// <reference lib="dom" />

interface IdleDeadline {
    timeRemaining(): DOMHighResTimeStamp;
    readonly didTimeout: boolean;
}

interface IdleRequestOptions {
    timeout?: number | undefined;
}

type IdleCallbackHandle = number;

interface Window {
    requestIdleCallback(callback: (deadline: IdleDeadline) => void, options?: IdleRequestOptions): IdleCallbackHandle;
    cancelIdleCallback(handle: number): void;
}

declare function requestIdleCallback(callback: (deadline: IdleDeadline) => void, options?: IdleRequestOptions): number;
declare function cancelIdleCallback(handle: number): void;

declare function request(callback: (deadline: IdleDeadline) => void, options?: IdleRequestOptions): IdleCallbackHandle;
declare function cancel(handle: IdleCallbackHandle): void;

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 15:11:36 GMT
 * Dependencies: none

# Credits
These definitions were written by [贺师俊](https://github.com/hax), [Max Boguslavskiy](https://github.com/maxbogus), and [Teramoto Daiki](https://github.com/teramotodaiki).
