import type { ImportSpecifier } from "estree";
/**
 * Turns a generic lodash import into a specific import using the CommonJS
 * lodash package.
 *
 * @param base "lodash" or "lodash/fp"
 * @param specifiers from an AST; assumes they are all ImportSpecifiers
 * @param appendDotJs optional, default is true; adds '.js' to the end of imports
 */
export declare function lodashSpecifiersToCjs(base: string, specifiers: Array<ImportSpecifier>, appendDotJs?: boolean): Array<string>;
//# sourceMappingURL=lodash-specifiers-to-cjs.d.ts.map