# PgHero

A performance dashboard for Postgres

[See it in action](https://pghero.dokkuapp.com/)

[![Screenshot](https://pghero.dokkuapp.com/assets/pghero-88a0d052.png)](https://pghero.dokkuapp.com/)

:tangerine: Battle-tested at [Instacart](https://www.instacart.com/opensource)

[![Build Status](https://github.com/ankane/pghero/actions/workflows/build.yml/badge.svg)](https://github.com/ankane/pghero/actions)

## Documentation

PgHero is available as a Docker image, Linux package, and Rails engine.

Select your preferred method of installation to get started.

- [Docker](guides/Docker.md)
- [Linux](guides/Linux.md)
- [Rails](guides/Rails.md)

## Related Projects

- [Dexter](https://github.com/ankane/dexter) - The automatic indexer for Postgres
- [PgBouncerHero](https://github.com/kwent/pgbouncerhero) - A dashboard for PgBouncer
- [pgsync](https://github.com/ankane/pgsync) - Sync Postgres data between databases
- [pgslice](https://github.com/ankane/pgslice) - Postgres partitioning as easy as pie

## Credits

A big thanks to [Craig Kerstiens](http://www.craigkerstiens.com/2013/01/10/more-on-postgres-performance/) and [Heroku](https://blog.heroku.com/archives/2013/5/10/more_insight_into_your_database_with_pgextras) for the initial queries and [Bootswatch](https://github.com/thomaspark/bootswatch) for the theme.

## History

View the [changelog](https://github.com/ankane/pghero/blob/master/CHANGELOG.md)

## Contributing

Everyone is encouraged to help improve this project. Here are a few ways you can help:

- [Report bugs](https://github.com/ankane/pghero/issues)
- Fix bugs and [submit pull requests](https://github.com/ankane/pghero/pulls)
- Write, clarify, or fix documentation
- Suggest or add new features
