import { PluginOption } from 'vite';
import { Config } from 'vite-plugin-full-reload';
import { Options as Options$1 } from 'vite-plugin-manifest-sri';
import { EnvVars, EnvOptions } from 'vite-plugin-environment';
import { Options as Options$2 } from 'vite-plugin-stimulus-hmr';
import { GzipPluginOptions } from 'rollup-plugin-gzip';

interface Options {
    /**
     * Whether to create compressed copies of relevant assets.
     *
     * Can use it to turn off `gzip` and `brotli` at once.
     *
     * @default true
     */
    compress?: boolean | {
        /**
         * Whether to create gzip copies of relevant assets.
         * @default true
         */
        gzip?: boolean;
        /**
         * Whether to create brotli copies of relevant assets.
         * @default true
         */
        brotli?: boolean;
    };
    /**
     * Options for rollup-plugin-gzip, will be used both for brotli and gzip.
     *
     * https://github.com/kryops/rollup-plugin-gzip
     */
    compression?: GzipPluginOptions;
    /**
     * Environment variables that should be exposed to the client build.
     *
     * By default, they are exposed under `import.meta.env`.
     *
     * https://github.com/ElMassimo/vite-plugin-environment
     */
    envVars?: EnvVars;
    /**
     * Options for vite-plugin-environment.
     *
     * By default, they are exposed under `import.meta.env`.
     *
     * https://github.com/ElMassimo/vite-plugin-environment
     */
    envOptions?: EnvOptions;
    /**
     * Options for vite-plugin-manifest-sri.
     *
     * https://github.com/ElMassimo/vite-plugin-manifest-sri
     */
    sri?: false | Options$1;
    /**
     * Options for vite-plugin-stimulus-hmr.
     *
     * https://github.com/ElMassimo/vite-plugin-stimulus-hmr
     */
    stimulus?: false | Options$2;
    /**
     * Options for vite-plugin-full-reload.
     *
     * By default it's configured for a standard Rails structure, assuming you
     * would want to automatically reload when modifying views or routes.
     *
     * https://github.com/ElMassimo/vite-plugin-full-reload
     */
    fullReload?: false | Config & {
        additionalPaths?: string | string[];
        overridePaths?: string | string[];
    };
}
declare function ViteRubyPlugin(options?: Options): PluginOption[];

export { Options, ViteRubyPlugin as default };
