"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  !mod.default ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  default: () => ViteRubyPlugin
});
module.exports = __toCommonJS(src_exports);
var import_zlib = require("zlib");
var import_vite_plugin_full_reload = __toESM(require("vite-plugin-full-reload"), 1);
var import_vite_plugin_manifest_sri = __toESM(require("vite-plugin-manifest-sri"), 1);
var import_vite_plugin_ruby = __toESM(require("vite-plugin-ruby"), 1);
var import_vite_plugin_environment = __toESM(require("vite-plugin-environment"), 1);
var import_vite_plugin_stimulus_hmr = __toESM(require("vite-plugin-stimulus-hmr"), 1);
var import_rollup_plugin_gzip = __toESM(require("rollup-plugin-gzip"), 1);
var defaultReloadPaths = [
  "config/routes.rb",
  "config/routes/*.rb",
  "app/views/**/*"
];
function ViteRubyPlugin(options = {}) {
  let { compress = true } = options;
  if (compress !== false)
    compress = { gzip: true, brotli: true, ...compress === true ? {} : compress };
  const envOptions = { defineOn: "import.meta.env", ...options.envOptions };
  const { overridePaths, additionalPaths = [], ...reloadOptions } = options.fullReload || {};
  const reloadPaths = overridePaths || [...defaultReloadPaths, ...wrapArray(additionalPaths)];
  const pluginOptions = [
    // Convention over configuration for Ruby projects using Vite.
    (0, import_vite_plugin_ruby.default)(),
    // Expose environment variables to your client code.
    options.envVars && (0, import_vite_plugin_environment.default)(options.envVars, envOptions),
    // Subresource Integrity for JavaScript and CSS assets.
    options.sri !== false && (0, import_vite_plugin_manifest_sri.default)(options.sri),
    // See changes to your controllers instantly without refreshing the page.
    options.stimulus !== false && (0, import_vite_plugin_stimulus_hmr.default)(options.stimulus),
    // Automatically reload the page when making changes to server files.
    options.fullReload !== false && (0, import_vite_plugin_full_reload.default)(reloadPaths, reloadOptions),
    // Create gzip copies of relevant assets.
    compress && compress.gzip && (0, import_rollup_plugin_gzip.default)(options.compression),
    // Create brotli copies of relevant assets.
    compress && compress.brotli && (0, import_rollup_plugin_gzip.default)({
      ...options.compression,
      customCompression: (content) => (0, import_zlib.brotliCompressSync)(Buffer.from(content)),
      fileName: ".br"
    })
  ];
  const plugins = pluginOptions.flat(Infinity).filter((plugin) => plugin);
  return [...plugins, dupDetector(plugins.map((plugin) => plugin.name))];
}
function wrapArray(array) {
  return Array.isArray(array) ? array : [array];
}
function dupDetector(originalPluginNames) {
  return {
    name: "vite-plugin-rails:dup-detector",
    configResolved(config) {
      if (config.plugins) {
        const pluginNames = new Set(originalPluginNames);
        pluginNames.delete("gzip");
        const pluginCounts = /* @__PURE__ */ Object.create(null);
        config.plugins.filter((plugin) => pluginNames.has(plugin.name)).forEach((plugin) => {
          pluginCounts[plugin.name] = (pluginCounts[plugin.name] || 0) + 1;
        });
        const duplicates = Object.entries(pluginCounts).filter(([name, count]) => count > 1).map(([name, count]) => name);
        if (duplicates.length) {
          throw new Error(`
            [vite-plugin-rails] Duplicate plugins detected: ${duplicates.join(", ")}.

            If migrating from vite-plugin-ruby, make sure to remove these manually added
            plugins, and instead pass the options to vite-plugin-rails.
          `);
        }
      }
    }
  };
}
