import AbstractHidden from './abstract_hidden';
import Tensor from '../tensor';
import type Abstract from './abstract';
import type { DenseOptions, ParamsAndGrads, Precision } from '../types';
declare class Dense extends AbstractHidden<DenseOptions> {
    bias: number;
    l1decay: number;
    l2decay: number;
    biased: boolean;
    biases: Tensor;
    filters: Tensor[];
    constructor(options: DenseOptions, prev?: Abstract);
    forward(input: Tensor, isTraining: boolean): Tensor;
    backward(): void;
    getAsOptions(precision: Precision): DenseOptions;
    getParamsAndGrads(): ParamsAndGrads[];
}
export default Dense;
