"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rule = exports.name = void 0;
const util_1 = require("../util");
exports.name = 'prefer-formatted-message';
exports.rule = {
    meta: {
        type: 'suggestion',
        docs: {
            description: 'Prefer `FormattedMessage` component over `intl.formatMessage` if applicable.',
            url: 'https://formatjs.github.io/docs/tooling/linter#prefer-formatted-message',
        },
        messages: {
            jsxChildren: 'Prefer `FormattedMessage` over `intl.formatMessage` in the JSX children expression.',
        },
        schema: [],
    },
    defaultOptions: [],
    // TODO: Vue support
    create(context) {
        return {
            JSXElement: (node) => {
                node.children.forEach(child => {
                    if (child.type !== 'JSXExpressionContainer' ||
                        !(0, util_1.isIntlFormatMessageCall)(child.expression)) {
                        return;
                    }
                    context.report({
                        node: child,
                        messageId: 'jsxChildren',
                    });
                });
            },
        };
    },
};
