import { parse } from '@formatjs/icu-messageformat-parser';
import { getParserServices } from '../context-compat';
import { extractMessages, getSettings } from '../util';
export const name = 'no-invalid-icu';
function checkNode(context, node) {
    const settings = getSettings(context);
    const msgs = extractMessages(node, settings);
    if (!msgs.length) {
        return;
    }
    for (const [{ message: { defaultMessage }, messageNode, },] of msgs) {
        if (!defaultMessage || !messageNode) {
            continue;
        }
        try {
            parse(defaultMessage, {
                ignoreTag: settings.ignoreTag,
            });
        }
        catch (e) {
            const msg = e instanceof Error ? e.message : e;
            context.report({
                node: messageNode,
                messageId: 'icuError',
                data: { message: `Error parsing ICU string: ${msg}` },
            });
        }
    }
}
export const rule = {
    meta: {
        type: 'problem',
        docs: {
            description: `Make sure ICU messages are formatted correctly with no bad select statements, plurals, etc.`,
        },
        fixable: 'code',
        schema: [],
        messages: {
            icuError: 'Invalid ICU Message format: {{message}}',
        },
    },
    defaultOptions: [],
    create(context) {
        const callExpressionVisitor = (node) => checkNode(context, node);
        const parserServices = getParserServices(context);
        //@ts-expect-error defineTemplateBodyVisitor exists in Vue parser
        if (parserServices?.defineTemplateBodyVisitor) {
            //@ts-expect-error
            return parserServices.defineTemplateBodyVisitor({
                CallExpression: callExpressionVisitor,
            }, {
                CallExpression: callExpressionVisitor,
            });
        }
        return {
            JSXOpeningElement: (node) => checkNode(context, node),
            CallExpression: callExpressionVisitor,
        };
    },
};
