import { RGBA } from './types';
/**
 * Blend two colors with the "normal" blend mode
 *
 * @param backdrop The background color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @param source   The foreground color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @return The blended color
 */
export declare function normal(backdrop: RGBA, source: RGBA): RGBA;
/**
 * Blend two colors with the "multiply" blend mode
 *
 * @param backdrop The background color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @param source   The foreground color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @return The blended color
 */
export declare function multiply(backdrop: RGBA, source: RGBA): RGBA;
/**
 * Blend two colors with the "screen" blend mode
 *
 * @param backdrop The background color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @param source   The foreground color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @return The blended color
 */
export declare function screen(backdrop: RGBA, source: RGBA): RGBA;
/**
 * Blend two colors with the "overlay" blend mode
 *
 * @param backdrop The background color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @param source   The foreground color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @return The blended color
 */
export declare function overlay(backdrop: RGBA, source: RGBA): RGBA;
/**
 * Blend two colors with the "darken" blend mode
 *
 * @param backdrop The background color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @param source   The foreground color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @return The blended color
 */
export declare function darken(backdrop: RGBA, source: RGBA): RGBA;
/**
 * Blend two colors with the "lighten" blend mode
 *
 * @param backdrop The background color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @param source   The foreground color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @return The blended color
 */
export declare function lighten(backdrop: RGBA, source: RGBA): RGBA;
/**
 * Blend two colors with the "color dodge" blend mode
 *
 * @param backdrop The background color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @param source   The foreground color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @return The blended color
 */
export declare function colorDodge(backdrop: RGBA, source: RGBA): RGBA;
/**
 * Blend two colors with the "color burn" blend mode
 *
 * @param backdrop The background color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @param source   The foreground color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @return The blended color
 */
export declare function colorBurn(backdrop: RGBA, source: RGBA): RGBA;
/**
 * Blend two colors with the "hard light" blend mode
 *
 * @param backdrop The background color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @param source   The foreground color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @return The blended color
 */
export declare function hardLight(backdrop: RGBA, source: RGBA): RGBA;
/**
 * Blend two colors with the "soft light" blend mode
 *
 * @param backdrop The background color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @param source   The foreground color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @return The blended color
 */
export declare function softLight(backdrop: RGBA, source: RGBA): RGBA;
/**
 * Blend two colors with the "difference" blend mode
 *
 * @param backdrop The background color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @param source   The foreground color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @return The blended color
 */
export declare function difference(backdrop: RGBA, source: RGBA): RGBA;
/**
 * Blend two colors with the "exclusion" blend mode
 *
 * @param backdrop The background color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @param source   The foreground color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @return The blended color
 */
export declare function exclusion(backdrop: RGBA, source: RGBA): RGBA;
/**
 * Blend two colors with the "hue" blend mode
 *
 * @param backdrop The background color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @param source   The foreground color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @return The blended color
 */
export declare function hue(backdrop: RGBA, source: RGBA): RGBA;
/**
 * Blend two colors with the "saturation" blend mode
 *
 * @param backdrop The background color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @param source   The foreground color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @return The blended color
 */
export declare function saturation(backdrop: RGBA, source: RGBA): RGBA;
/**
 * Blend two colors with the "color" blend mode
 *
 * @param backdrop The background color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @param source   The foreground color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @return The blended color
 */
export declare function color(backdrop: RGBA, source: RGBA): RGBA;
/**
 * Blend two colors with the "luminosity" blend mode
 *
 * @param backdrop The background color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @param source   The foreground color object { r,g,b,a } with the color channels being integers in the [0..255] range and the alpha channel being a fraction in [0..1]
 * @return The blended color
 */
export declare function luminosity(backdrop: RGBA, source: RGBA): RGBA;
//# sourceMappingURL=index.d.ts.map