"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.visitor = void 0;
const tslib_1 = require("tslib");
const t = tslib_1.__importStar(require("@babel/types"));
const icu_messageformat_parser_1 = require("@formatjs/icu-messageformat-parser");
const utils_1 = require("../utils");
const visitor = function (path, { opts, file: { opts: { filename }, }, }) {
    const { removeDefaultMessage, idInterpolationPattern, overrideIdFn, ast, preserveWhitespace, } = opts;
    const { componentNames, messages } = this;
    if ((0, utils_1.wasExtracted)(path)) {
        return;
    }
    const name = path.get('name');
    if (!componentNames.find(n => name.isJSXIdentifier({ name: n }))) {
        return;
    }
    const attributes = path
        .get('attributes')
        .filter(attr => attr.isJSXAttribute());
    const descriptorPath = (0, utils_1.createMessageDescriptor)(attributes.map(attr => [
        attr.get('name'),
        attr.get('value'),
    ]));
    // In order for a default message to be extracted when
    // declaring a JSX element, it must be done with standard
    // `key=value` attributes. But it's completely valid to
    // write `<FormattedMessage {...descriptor} />`, because it will be
    // skipped here and extracted elsewhere. The descriptor will
    // be extracted only (storeMessage) if a `defaultMessage` prop.
    if (!descriptorPath.defaultMessage) {
        return;
    }
    // Evaluate the Message Descriptor values in a JSX
    // context, then store it.
    const descriptor = (0, utils_1.evaluateMessageDescriptor)(descriptorPath, true, filename || undefined, idInterpolationPattern, overrideIdFn, preserveWhitespace);
    (0, utils_1.storeMessage)(descriptor, path, opts, filename || undefined, messages);
    let idAttr;
    let descriptionAttr;
    let defaultMessageAttr;
    const firstAttr = attributes[0];
    for (const attr of attributes) {
        if (!attr.isJSXAttribute()) {
            continue;
        }
        switch ((0, utils_1.getMessageDescriptorKey)(attr.get('name'))) {
            case 'description':
                descriptionAttr = attr;
                break;
            case 'defaultMessage':
                defaultMessageAttr = attr;
                break;
            case 'id':
                idAttr = attr;
                break;
        }
    }
    // Insert ID before removing node to prevent null node insertBefore
    if (overrideIdFn || (descriptor.id && idInterpolationPattern)) {
        if (idAttr) {
            idAttr.get('value').replaceWith(t.stringLiteral(descriptor.id));
        }
        else if (firstAttr) {
            firstAttr.insertBefore(t.jsxAttribute(t.jsxIdentifier('id'), t.stringLiteral(descriptor.id)));
        }
    }
    if (descriptionAttr) {
        descriptionAttr.remove();
    }
    if (defaultMessageAttr) {
        if (removeDefaultMessage) {
            defaultMessageAttr.remove();
        }
        else if (ast && descriptor.defaultMessage) {
            defaultMessageAttr
                .get('value')
                .replaceWith(t.jsxExpressionContainer(t.nullLiteral()));
            const valueAttr = defaultMessageAttr.get('value');
            valueAttr
                .get('expression')
                .replaceWithSourceString(JSON.stringify((0, icu_messageformat_parser_1.parse)(descriptor.defaultMessage)));
        }
    }
    // Tag the AST node so we don't try to extract it twice.
    (0, utils_1.tagAsExtracted)(path);
};
exports.visitor = visitor;
