/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2025 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package blues;

import java.io.IOException;

class Comm extends AbstractComm {

    Comm(int port) {
        super(port);
    }

    @Override
    protected boolean processCommand(int command) throws IOException {
        switch (command) {
        case 1:
            cmdGetVersion();
            break;
        case 2:
            cmdPollRequest();
            break;
        case 3:
            cmdWaitRequest();
            break;
        case 4:
            cmdSubmitResponse();
            break;
        case 5:
            cmdExecAction();
            break;
        case 6:
            cmdCreateContainer();
            break;
        case 7:
            cmdDestroyContainer();
            break;

        case 100:
            cmdTestBlob();
            break;
        default:
            return false;
        }
        return true;
    }

    private void cmdGetVersion() throws IOException {
        out().writeInt(2);
        out().flush();
    }

    private void cmdPollRequest() throws IOException {
        Blob.writeBlob(out(), Server.pollRequest());
    }

    private void cmdWaitRequest() throws IOException {
        long timeout = in().readLong();
        Blob.writeBlob(out(), Server.waitRequest(timeout));
    }

    private void cmdSubmitResponse() throws IOException {
        Blob response = Blob.readBlob(in());
        Server.submitRespone(response);
    }

    private Action onExecActionFinished = new Action() {
        @Override
        public Blob action(Blob result) throws Exception {
            if (null == result)
                throw new IllegalArgumentException();
            Server.getInstance().putActionResponse(result);
            return null;
        }
    };

    private void cmdExecAction() throws IOException {
        int containerId  = in().readInt();
        String actionName = in().readUTF();
        Blob action = Blob.readBlob(in());
        if (action != null) {
            Server.execAction(containerId,actionName,action,onExecActionFinished);
        }
    }

    private void cmdCreateContainer() throws IOException {
        out().writeInt(Server.createContainer());
        out().flush();
    }

    private void cmdDestroyContainer() throws IOException {
        int containerId  = in().readInt();
        Server.destroyContainer(containerId);
        out().writeInt(0);
        out().flush();
    }

    private void cmdTestBlob() throws IOException {
        Blob blob = new Blob(0x12345678);
        blob.args = new int[] { 1, 2, 3, 4, 5 };
        blob.strings = new String[] { "string1", "Str2", "sTringstring3" };
        // blob.data = new byte[] { 7 ,8 ,9 , 10 };
        Blob.writeBlob(out(), blob);
    }

    @Override
    protected void cleanupResources() {
        Server.close();
    }
}
