#!/usr/bin/env bash

### Path to lock file
LIMINE_LOCK_FILE="/tmp/limine-global.lock"

mutex_lock() {
    local name=$1
    exec 200>${LIMINE_LOCK_FILE} || {
        echo -e "\033[1;31m Failed to open the lock file ${LIMINE_LOCK_FILE}.\033[0m" >&2
        return 1
    }
    flock --timeout=60 200 || {
        echo -e "\033[1;31m Mutex lock timeout on ${name}.\033[0m" >&2
        return 1
    }
}

mutex_unlock() {
    # Release the lock
    flock --unlock 200
}

sleep 1

mutex_lock "wait-for-limine-snapper-sync"
mutex_unlock
